% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{match_calls}
\alias{match_calls}
\title{Recursively match calls and modify arguments}
\usage{
match_calls(
  call,
  recursive = TRUE,
  replace_args = list(),
  quoted = FALSE,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{call}{an \code{R} expression}

\item{recursive}{logical, recursively match calls, default is true}

\item{replace_args}{named list of functions, see examples}

\item{quoted}{logical, is \code{call} quoted}

\item{envir}{which environment should call be evaluated}

\item{...}{other parameters passing to \code{match.call}}
}
\value{
A nested call with all arguments matched
}
\description{
Recursively match calls and modify arguments
}
\examples{
library(dipsaus); library(shiny)

# In shiny modules, we might want to add ns() to inputIds
# In this example, textInput(id) will become textInput(ns(id))
match_calls(lapply(1:20, function(i){
  textInput(paste('id_', i), paste('Label ', i))
}), replace_args = list(
  inputId = function(arg, call){ as.call(list(quote(ns), arg)) }
))

}
