% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallels-apply-script.R
\name{lapply_callr}
\alias{lapply_callr}
\title{Apply function with \code{rs_exec}}
\usage{
lapply_callr(
  x,
  fun,
  ...,
  .callback = NULL,
  .globals = list(),
  .ncores = future::availableCores(),
  .packages = attached_packages(),
  .focus_on_console = TRUE,
  .rs = FALSE,
  .quiet = FALSE,
  .name = "",
  .wait = TRUE
)
}
\arguments{
\item{x}{vector or list}

\item{fun}{function}

\item{...}{passed to function, see \code{\link{lapply}}}

\item{.callback}{a function takes zero, one, or two arguments
and should return a string to show in the progress}

\item{.globals}{a named list that \code{fun} relies on}

\item{.ncores}{number of cores to use; only used when \code{.wait=TRUE}}

\item{.packages}{packages to load}

\item{.focus_on_console}{whether to focus on console once finished;
is only used when \code{.rs} is true}

\item{.rs}{whether to create 'RStudio' jobs; default is false}

\item{.quiet}{whether to suppress progress message}

\item{.name}{the name of progress and jobs}

\item{.wait}{whether to wait for the results; default is true, which blocks
the main session waiting for results.}
}
\value{
When \code{.wait=TRUE}, returns a list that should be, in most of
the cases, identical to \code{\link{lapply}}; when \code{.wait=FALSE},
returns a function that collects results.
}
\description{
Apply function with \code{rs_exec}
}
\examples{

if(interactive()){

  lapply_callr(1:3, function(x, a){
    c(Sys.getpid(), a, x)
  }, a = 1)

  lapply_callr(1:30, function(x)
    {
      Sys.sleep(0.1)
      sprintf("a + x = \%d", a + x)
    }, .globals = list(a = 1),
    .callback = I, .name = "Test")

}

}
\seealso{
\code{\link{rs_exec}}
}
