% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{test_farg}
\alias{test_farg}
\title{Test whether function has certain arguments}
\usage{
test_farg(fun, arg, dots = TRUE)
}
\arguments{
\item{fun}{function}

\item{arg}{characters of function arguments}

\item{dots}{whether \code{fun}'s dots (\code{...}) counts}
}
\description{
Test whether function has certain arguments
}
\examples{

a <- function(n = 1){}

# Test whether `a` has argument called 'b'
test_farg(a, 'b')

# Test whether `a` has argument called 'b' and 'n'
test_farg(a, c('b', 'n'))

# `a` now has dots
a <- function(n = 1, ...){}

# 'b' could goes to dots and a(b=...) is still valid
test_farg(a, 'b')

# strict match, dots doesn't count
test_farg(a, 'b', dots = FALSE)

}
