% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{predict.dfm}
\alias{predict.dfm}
\alias{print.dfm_forecast}
\alias{plot.dfm_forecast}
\alias{as.data.frame.dfm_forecast}
\title{DFM Forecasts}
\usage{
\method{predict}{dfm}(
  object,
  h = 10L,
  method = switch(object$em.method, none = "2s", "qml"),
  standardized = TRUE,
  resFUN = NULL,
  resAC = 0.1,
  ...
)

\method{print}{dfm_forecast}(x, digits = 4L, ...)

\method{plot}{dfm_forecast}(
  x,
  main = paste(x$h, "Period Ahead DFM Forecast"),
  xlab = "Time",
  ylab = "Standardized Data",
  factors = seq_len(ncol(x$F)),
  scale.factors = TRUE,
  factor.col = rainbow(length(factors)),
  factor.lwd = 1.5,
  fcst.lty = "dashed",
  data.col = c("grey85", "grey65"),
  legend = TRUE,
  legend.items = paste0("f", factors),
  grid = FALSE,
  vline = TRUE,
  vline.lty = "dotted",
  vline.col = "black",
  ...
)

\method{as.data.frame}{dfm_forecast}(
  x,
  ...,
  use = c("factors", "data", "both"),
  pivot = c("long", "wide"),
  time = seq_len(nrow(x$F) + x$h),
  stringsAsFactors = TRUE
)
}
\arguments{
\item{object}{an object of class 'dfm'.}

\item{h}{integer. The forecast horizon.}

\item{method}{character. The factor estimates to use: one of \code{"qml"}, \code{"2s"} or \code{"pca"}.}

\item{standardized}{logical. \code{FALSE} will return data forecasts on the original scale.}

\item{resFUN}{an (optional) function to compute a univariate forecast of the residuals.
The function needs to have a second argument providing the forecast horizon (\code{h}) and return a vector or forecasts. See Examples.}

\item{resAC}{numeric. Threshold for residual autocorrelation to apply \code{resFUN}: only residual series where AC1 > resAC will be forecasted.}

\item{\dots}{not used.}

\item{x}{an object class 'dfm_forecast'.}

\item{digits}{integer. The number of digits to print out.}

\item{main, xlab, ylab}{character. Graphical parameters passed to \code{\link{ts.plot}}.}

\item{factors}{integers indicating which factors to display. Setting this to \code{NA}, \code{NULL} or \code{0} will omit factor plots.}

\item{scale.factors}{logical. Standardize factor estimates, this usually improves the plot since the factor estimates corresponding to the greatest PCA eigenvalues tend to have a greater variance than the data.}

\item{factor.col, factor.lwd}{graphical parameters affecting the colour and line width of factor estimates plots. See \code{\link{par}}.}

\item{fcst.lty}{integer or character giving the line type of the forecasts of factors and data. See \code{\link{par}}.}

\item{data.col}{character vector of length 2 indicating the colours of historical data and forecasts of that data. Setting this to \code{NA}, \code{NULL} or \code{""} will not plot data and data forecasts.}

\item{legend}{logical. \code{TRUE} draws a legend in the top-left of the chart.}

\item{legend.items}{character names of factors for the legend.}

\item{grid}{logical. \code{TRUE} draws a grid on the background of the plot.}

\item{vline}{logical. \code{TRUE} draws a vertical line deliminating historical data and forecasts.}

\item{vline.lty, vline.col}{graphical parameters affecting the appearance of the vertical line. See \code{\link{par}}.}

\item{use}{character. Which forecasts to use \code{"factors"}, \code{"data"} or \code{"both"}.}

\item{pivot}{character. The orientation of the frame: \code{"long"} or \code{"wide"}.}

\item{time}{a vector identifying the time dimension, must be of length T + h, or \code{NULL} to omit a time variable.}

\item{stringsAsFactors}{logical. If \code{TRUE} and \code{pivot = "long"} the 'Variable' column is created as a factor. Same as option to \code{\link{as.data.frame.table}}.}
}
\value{
A list-like object of class 'dfm_forecast' with the following elements:
\item{\code{X_fcst}}{\eqn{h \times n}{h x n} matrix with the forecasts of the variables. }
\item{\code{F_fcst}}{\eqn{h \times r}{h x r} matrix with the factor forecasts. }
\item{\code{X}}{\eqn{T \times n}{T x n} matrix with the standardized (scaled and centered) data - with attributes attached allowing reconstruction of the original data:
\tabular{llll}{
\code{"stats"} \tab\tab is a \eqn{n \times 5}{n x 5} matrix of summary statistics of class \code{"qsu"} (see \code{\link[collapse]{qsu}}). Only attached if \code{standardized = TRUE}. \cr\cr
\code{"attributes"} \tab\tab contains the \code{\link{attributes}} of the original data input.\cr\cr
\code{"is.list"} \tab\tab is a logical value indicating whether the original data input was a list / data frame. \cr\cr
}
}
\item{\code{F}}{\eqn{T \times r}{T x r} matrix of factor estimates. }
\item{\code{method}}{the factor estimation method used.}
\item{\code{anyNA}}{logical indicating whether \code{X} contains any missing values.}
\item{\code{h}}{the forecast horizon.}
\item{\code{resid.fc}}{logical indicating whether a univariate forecasting function was applied to the residuals.}
\item{\code{resid.fc.ind}}{indices indicating for which variables (columns of \code{X}) the residuals were forecasted using the univariate function.}
\item{\code{call}}{call object obtained from \code{match.call()}.}
}
\description{
This function produces h-step ahead forecasts of both the factors and the data,
with an option to also forecast autocorrelated residuals with a univariate method and produce a combined forecast.
}
\examples{
\donttest{
library(xts)
library(collapse)

# Fit DFM with 3 factors and 3 lags in the transition equation
mod = DFM(diff(BM14_M), r = 3, p = 3)

# 15 period ahead forecast
fc = predict(mod, h = 15)
print(fc)
plot(fc, xlim = c(300, 370))

# Also forecasting autocorrelated residuals with an AR(1)
fcfun <- function(x, h) predict(ar(na_rm(x)), n.ahead = h)$pred
fcar = predict(mod, resFUN = fcfun, h = 15)
plot(fcar, xlim = c(300, 370))

# Retrieving a data frame of the forecasts
head(as.data.frame(fcar, pivot = "wide")) # Factors
head(as.data.frame(fcar, use = "data"))   # Data
head(as.data.frame(fcar, use = "both"))   # Both
}
}
