% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pillar_stats.R
\name{brightness_pillars}
\alias{brightness_pillars}
\title{Get the brightness of pillars of a 3d array.}
\usage{
brightness_pillars(img, parallel = FALSE)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{parallel}{Would you like to use multiple cores to speed up this
function? If so, set the number of cores here, or to use all available
cores, use \code{parallel = TRUE}.}
}
\value{
An \link[ijtiff:ijtiff_img]{ijtiff_img}-style array \code{arr} with
one frame. \code{arr[y, x, ch, 1]} is equal to \code{var(img[y, x, ch, ]) / mean(img[y, x, ch, ])}.
}
\description{
For an \link[ijtiff:ijtiff_img]{ijtiff_img}-style array \code{img} (indexed as \code{img[y, x, channel, frame]}),  3-dimensional array \code{mat3d}, pillar \code{xy}  of channel
\code{ch} is defined as \code{img[y, x, ch, ]}. This function computes the brightness,
of each pillar.
}
\examples{
aaa <- array(1:16, dim = c(2, 2, 4))
brightness_pillars(aaa)
}
