% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sep.r
\name{sep}
\alias{sep}
\title{sep}
\usage{
sep(x, k)
}
\arguments{
\item{x}{A deque.}

\item{k}{Index to split the deque at.}
}
\value{
A deque, stack, or queue (depending on the input)
}
\description{
Spliot one object (queue/stack/deque) into two of the same type. NOTE: this
function operates via side-effects AND has a return.
}
\details{
Operates via side-effects ALTHOUGH THERE IS A NON-NULL RETURN; see examples
for clarification on usage.

The split occurs after index k.  So if the input x has, say,
elements 1 to n, then after running \code{sep(x, k)}, x will
have elements 1 to k, and the return will have values
k+1, k+2, ..., n.
}
\examples{
\dontrun{
library(dequer)
s <- stack()
for (i in 1:5) push(s, i)

### Split s into 2 stacks holding: (s) the first 3, and (s_last_2) last 2 elements
s_last_2 <- sep(s, 3)

str(s)
str(s_last_5)
}

}
