% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dca.r
\name{dca}
\alias{dca}
\title{Perform Decision Curve Analysis}
\usage{
dca(
  formula,
  data,
  thresholds = seq(0, 0.99, by = 0.01),
  label = NULL,
  harm = NULL,
  as_probability = character(),
  time = NULL,
  prevalence = NULL
)
}
\arguments{
\item{formula}{a formula with the outcome on the LHS and a sum of
markers/covariates to test on the RHS}

\item{data}{a data frame containing the variables in \verb{formula=}.}

\item{thresholds}{vector of threshold probabilities between 0 and 1.
Default is \code{seq(0, 0.99, by = 0.01)}. Thresholds at zero are replaced
with 10e-10.}

\item{label}{named list of variable labels, e.g. \code{list(age = "Age, years")}}

\item{harm}{named list of harms associated with a test. Default is \code{NULL}}

\item{as_probability}{character vector including names of variables
that will be converted to a probability. Details below.}

\item{time}{if outcome is survival, \verb{time=} specifies the time the
assessment is made}

\item{prevalence}{When \code{NULL}, the prevalence is estimated from \verb{data=}.
If the data passed is a case-control set, the population prevalence
may be set with this argument.}
}
\value{
List including net benefit of each variable
}
\description{
Diagnostic and prognostic models are typically evaluated with measures of
accuracy that do not address clinical consequences.
Decision-analytic techniques allow assessment of clinical outcomes but often
require collection of additional information may be cumbersome to apply to
models that yield a continuous result. Decision curve analysis is a method
for evaluating and comparing prediction models that incorporates clinical
consequences, requires only the data set on which the models are tested,
and can be applied to models that have either continuous or dichotomous
results.
The dca function performs decision curve analysis for binary outcomes.
Review the
\href{https://www.danieldsjoberg.com/dcurves/articles/dca.html}{DCA Vignette}
for a detailed walk-through of various applications.
Also, see \href{https://www.mskcc.org/departments/epidemiology-biostatistics/biostatistics/decision-curve-analysis}{www.decisioncurveanalysis.org} for more information.
}
\section{as_probability argument}{

While the \verb{as_probability=} argument can be used to convert a marker to the
probability scale, use the argument only when the consequences are fully
understood. For example, when the outcome is binary, logistic regression
is used to convert the marker to a probability. The logistic regression
model assumes linearity on the log-odds scale and can induce
miscalibration when this assumption is not true. Miscalibration in a
model will adversely affect performance on decision curve
analysis. Similarly, when the outcome is time-to-event, Cox Proportional
Hazards regression is used to convert the marker to a probability.
The Cox model also has a linearity assumption and additionally assumes
proportional hazards over the follow-up period. When these assumptions
are violated, important miscalibration may occur.

Instead of using the \verb{as_probability=} argument, it is suggested to perform
the regression modeling outside of the \code{dca()} function utilizing methods,
such as non-linear modeling, as appropriate.
}

\examples{
# calculate DCA with binary endpoint
dca(cancer ~ cancerpredmarker + marker,
    data = df_binary,
    as_probability = "marker",
    label = list(cancerpredmarker = "Prediction Model", marker = "Biomarker")) \%>\%
  # plot DCA curves with ggplot
  plot(smooth = TRUE) +
  # add ggplot formatting
  ggplot2::labs(x = "Treatment Threshold Probability")

# calculate DCA with time to event endpoint
dca(Surv(ttcancer, cancer) ~ cancerpredmarker, data = df_surv, time = 1)
}
\seealso{
\code{\link[=net_intervention_avoided]{net_intervention_avoided()}}, \code{\link[=standardized_net_benefit]{standardized_net_benefit()}}, \code{\link[=plot.dca]{plot.dca()}},
\code{\link[=as_tibble.dca]{as_tibble.dca()}}
}
\author{
Daniel D Sjoberg
}
