% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbn_inference.R
\name{predict_bn}
\alias{predict_bn}
\title{Performs inference over a fitted GBN}
\usage{
predict_bn(fit, evidence)
}
\arguments{
\item{fit}{the fitted bn}

\item{evidence}{values of the variables used as evidence for the net}
}
\value{
the mean of the particles for each row
}
\description{
Performs inference over a Gaussian BN. It's thought to be used in a map for
a data.table, to use as evidence each separate row. If not specifically
needed, it's recommended to use the function \code{\link{predict_dt}} instead.
}
\examples{
size = 3
data(motor)
dt_train <- motor[200:2500]
dt_val <- motor[2501:3000]
net <- learn_dbn_struc(dt_train, size)
f_dt_train <- fold_dt(dt_train, size)
f_dt_val <- fold_dt(dt_val, size)
fit <- fit_dbn_params(net, f_dt_train, method = "mle")
res <- f_dt_val[, predict_bn(fit, .SD), by = 1:nrow(f_dt_val)]
}
