% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D1Node.R
\docType{methods}
\name{query}
\alias{query}
\alias{query,D1Node-method}
\title{Search DataONE for data and metadata objects}
\usage{
query(x, ...)

\S4method{query}{D1Node}(x, solrQuery = as.character(NA), encode = TRUE,
  as = "list", parse = TRUE, searchTerms = as.character(NA),
  encodeReserved = FALSE, ...)
}
\arguments{
\item{x}{The CNode or MNode instance to send the query to.}

\item{...}{(Not yet used.)}

\item{solrQuery}{The query search terms, either as a string or as list with named members.}

\item{encode}{A logical, if \code{TRUE} then the query is URL encoded. The default is \code{TRUE}.}

\item{as}{The return type. Possible values: "json", "xml", "list" or "data.frame" with "list" as the default.}

\item{parse}{A logical value. If TRUE, then the result is parsed and converted to appropriate R data types. If FALSE, character values are returned.}

\item{searchTerms}{A list of name / value pairs (an alternative to \code{solrQuery}).}

\item{encodeReserved}{A logical, if TRUE then reserved characters in the query are URL encoded (FALSE is default). See \code{URLencode} for details.}
}
\value{
search results as a list, data.frame or XML document
}
\description{
The DataONE search index is searched for data that matches the specified query parameters.
}
\details{
The \code{"query"} method sends a query to a DataONE search index that uses the Apache Solr search 
engine \url{http://lucene.apache.org/solr/}. This same Solr search engine is the underlying mechanism used by the
DataONE online search tool available at \url{https://search.dataone.org/}.

The \code{"solrQuery"} argument is used to specify search terms that data of interest must match. This parameter uses
Solr query terms, so some familiarity with Solr is helpful, however, fairly simple queries can be effective. This
argument can be created as either a single character string containing the Solr query, for example: \code{solrQuery = "q=id:doi*&rows=2&wt=json"},
or as a list of key value pairs: \code{solrQuery = list(q = "id:doi*", rows = "2", wt = "json")}. These two queries produce the same result.

As an alternative to specifying the Solr query terms using the \code{"solrquery"} argument, the \code{"searchTerms"} argument
can be specified, which does not require any Solr syntax. This parameter is a list with query field / value pairs, i.e. 
\code{searchTerms=list(abstract=kelp, attribute=biomass)}.
The query fields can be listed for a DataONE node using \code{\link{getQueryEngineDescription}}.
Either \code{"searchTerms"} or \code{"solrQuery"} must be specified.

The \code{"as"} argument is used to specify the query result to be returned as: "json", xml", "list", "data.frame".

The \code{"parsed"} argument, if specified as TRUE, causes the query result to be converted to appropriate R data types.
For example, if \code{ar = "xml"} and \code{parsed = TRUE}, then the query result is returned as an R XMLInternalDocument, or 
If \code{'parsed = FALSE'} then a character variable with the XML string is returned. Specify \code{as = "list"} to have 
the result parseed to an R list, with each list element containing one Solr query result of the total result set.
}
\examples{
\dontrun{
library(dataone)
cn <- CNode("PROD")
queryParams <- list(q="id:doi*", rows="5", 
    fq="(abstract:chlorophyll AND dateUploaded:[2000-01-01T00:00:00Z TO NOW])", 
    fl="title,id,abstract,size,dateUploaded,attributeName")
# Return result as a list.
result <- query(cn, queryParams, as="list")

# Query and return the result as a data.frame of character values.
queryParams <- list(q="id:doi*", rows="3", 
    fq="(abstract:chlorophyll AND dateUploaded:[2000-01-01T00:00:00Z TO NOW])", 
    fl="title,id,abstract,size,dateUploaded,attributeName")
result <- query(cn, queryParams, as="data.frame", parse=FALSE)

# Return the result as JSON
queryParams <- "q=id:doi*&rows=2&wt=json"
result <- query(cn, queryParams, as="json")

# The following query shows how to embed quotes
cn <- CNode("SANDBOX2")
queryParamList <- list(q="(attribute:lake) and (attribute:\\"Percent Nitrogen\\")", rows="1000",
                       fl="title,id,abstract,size,dateUploaded,attributeName", wt="xml")
result <- query(cn, queryParamList, as="data.frame")

# The following query uses the searchTerms parameter
cn <- CNode()
mn <- getMNode(cn, "urn:node:KNB")
mySearchTerms <- list(abstract="kelp", attribute="biomass")
result <- query(mn, searchTerms=mySearchTerms, as="data.frame")
}
}

