% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{plot_ppc}
\alias{plot_ppc}
\title{Creates a PPC plot for a single dataset}
\usage{
plot_ppc(
  rs_mean,
  rs_range,
  col_number = 2,
  obs_mean = NULL,
  obs_full = NULL,
  xy_lim = NULL,
  study = NULL
)
}
\arguments{
\item{rs_mean}{\code{data.frame}, model results best fit params}

\item{rs_range}{\code{data.frame}, predictions (min, max from param.sample run)}

\item{col_number, }{column to plot, default = 2}

\item{obs_mean}{\code{data.frame}, observations with means per treatment level}

\item{obs_full}{\code{data.frame}, full data set including results for replicates}

\item{xy_lim}{optional \code{numeric}, limits of x and y axis for plotting}

\item{study}{optional \code{string}, name of study which can be used as key}
}
\value{
a ggplot2 plot object
}
\description{
A sample of parameters representing the uncertainty within the dataset
is passed to the function. All parameter combinations and exposure patterns
are simulated and the range of predicted frond numbers is derived for a
single study. The uncertainty is displayed by a Posterior Predictive Plot
(PPC). The data (rs_mean, obs_mean and obs_full) must have the
following format (col1 = time, col2 = data of interest, col3 = trial name).
Data for uncertainties (rs_range) must have the format: col1 = time,
col2 = lower boundaries, col3 = upper boundaries, col4 = trial. The user
should take care of the input data and consider whether control data and
data at time zero should be included in the model check.
}
