% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cubble-attr.R
\name{form}
\alias{form}
\alias{is_long}
\alias{is_nested}
\alias{spatial}
\alias{key_vars}
\alias{key_data}
\alias{coords}
\alias{coord_x}
\alias{coord_y}
\alias{index}
\title{Functions to extract cubble attributes}
\usage{
form(data)

is_long(data)

is_nested(data)

spatial(data)

key_vars(data)

key_data(data)

coords(data)

coord_x(data)

coord_y(data)

index(data)
}
\arguments{
\item{data}{an cubble object}
}
\value{
the name of cubble attributes
}
\description{
Functions to extract cubble attributes
}
\details{
Apart from inheriting attributes \code{names}, \code{row.names}, and \code{class} from the underlying tibble,
a cubble has its site identifier: \code{key}, temporal identifier, \code{index}, and
spatial coordinate reference: \code{coords}.

If a cubble object is also a tsibble, then tsibble attributes (\code{key}, \code{index}, \code{index2}, \code{interval})
are also preserved and can be accessed via the relevant functions in the tsibble package. (NOT FULLY IMPLEMENTED)
}
\examples{
# extract attributes of a cubble object
form(climate_aus)
spatial(climate_aus) \%>\% head(5)
key_data(climate_aus) \%>\% head(5)
key_vars(climate_aus)
index(climate_aus)
coords(climate_aus)
coord_x(climate_aus)
coord_y(climate_aus)

}
