% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctrLoadQueryIntoDb.R
\name{ctrLoadQueryIntoDb}
\alias{ctrLoadQueryIntoDb}
\title{Load and store register trial information}
\usage{
ctrLoadQueryIntoDb(
  queryterm = NULL,
  register = "",
  querytoupdate = NULL,
  forcetoupdate = FALSE,
  euctrresults = FALSE,
  euctrresultshistory = FALSE,
  documents.path = NULL,
  documents.regexp = "prot|sample|statist|sap_|p1ar|p2ars|ctalett|lay|^[0-9]+ ",
  annotation.text = "",
  annotation.mode = "append",
  only.count = FALSE,
  con = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{queryterm}{Either a string with the full URL of a search
query in a register, or the data frame returned by the
\link{ctrGetQueryUrl} or the
\link{dbQueryHistory} functions, or, together with parameter
\code{register}, a string with query elements of a search URL.
The query details are recorded in the \code{collection} for
later use to update records.
For "CTIS", \code{queryterm} can be an empty string to obtain
all trial records. For automatically copying the user's
query of a register in a web browser to the clipboard, see
\ifelse{latex}{\out{\href{https://github.com/rfhb/ctrdata\#3-script-to-automatically-copy-users-query-from-web-browser}{here}}}{\href{https://github.com/rfhb/ctrdata#3-script-to-automatically-copy-users-query-from-web-browser}{here}}}

\item{register}{String with abbreviation of register to query,
either "EUCTR", "CTGOV", "ISRCTN" or "CTIS". Not needed
if \code{queryterm} provides a full URL to query results.}

\item{querytoupdate}{Either the word "last", or the row number of
a query in the data frame returned by \link{dbQueryHistory} that
should be run to retrieve any new or update trial records since
this query was run the last time.
This parameter takes precedence over \code{queryterm}.
For "EUCTR", updates are available only for the last seven days;
the query is run again if more time has passed since it was
run last.
Does not work with "CTIS" at this time.}

\item{forcetoupdate}{If \code{TRUE}, run again the query
given in \code{querytoupdate}, irrespective of when it was
run last. Default is \code{FALSE}.}

\item{euctrresults}{If \code{TRUE}, also download available
results when retrieving and loading trials from EUCTR. This
slows down this function. (For "CTGOV", "CTGOV2" and "CTIS",
all available results are always retrieved and loaded into the
collection.)}

\item{euctrresultshistory}{If \code{TRUE}, also download
available history of results publication in "EUCTR."
This is quite time-consuming. Default is \code{FALSE}.}

\item{documents.path}{If this is a relative or absolute
path to a directory that exists or can be created,
save any documents into it that are directly available from
the register ("EUCTR", "CTGOV", "CTGOV2", "ISRCTN", "CTIS")
such as PDFs on results, analysis plans, spreadsheets,
patient information sheets, assessments or product information.
Default is \code{NULL}, which disables saving documents.}

\item{documents.regexp}{Regular expression, case insensitive,
to select documents, if saving documents is requested
(see \code{documents.path}).
If set to \code{NULL}, empty placeholder files are saved for
every document that could be saved. Default is
\code{"prot|sample|statist|sap_|p1ar|p2ars|ctalett|lay|^[0-9]+ "}.
Used with "CTGOV", "CTGOV2", "ISRCTN" and "CTIS" (but not "EUCTR",
for which all available documents are saved in any case).}

\item{annotation.text}{Text to be including into the field
"annotation" in the records retrieved with the query
that is to be loaded into the collection.
The contents of the field "annotation" for a trial record
are preserved e.g. when running this function again and
loading a record of a with an annotation, see parameter
\code{annotation.mode}.}

\item{annotation.mode}{One of "append" (default), "prepend"
or "replace" for new annotation.text with respect to any
existing annotation for the records retrieved with the query
that is to be loaded into the collection.}

\item{only.count}{Set to \code{TRUE} to return only the
number of trial records found in the register for the query.
Does not load trial information into the database.
Default is \code{FALSE}.}

\item{con}{A connection object, see section
`Databases` in \link{ctrdata}.}

\item{verbose}{Printing additional information if set to
\code{TRUE}; default is \code{FALSE}.}

\item{...}{Do not use (capture deprecated parameters).}
}
\value{
A list with elements
`n` (number of trial records newly imported or updated),
`success` (a vector of _id's of successfully loaded records),
`failed` (a vector of identifiers of records that failed to load)
and `queryterm` (the query term used).
The returned list has several attributes (including database and
collection name, as well as the query history of this database
collection) to facilitate documentation.
}
\description{
Retrieves information on clinical trials from registers
and stores it in a collection in a database. Main function
of \link{ctrdata} for accessing registers.
A collection can store trial information from different queries
or different registers. Query details are stored in the
collection and can be accessed using \link{dbQueryHistory}.
A previous query can be re-run, which replaces or adds trial
records while keeping any user annotations of trial records.
}
\examples{
\dontrun{

dbc <- nodbi::src_sqlite(collection = "my_collection")

# Retrieve protocol- and results-related information
# on two specific trials identified by their EU number
ctrLoadQueryIntoDb(
  queryterm = "2005-001267-63+OR+2008-003606-33",
  register = "EUCTR",
  euctrresults = TRUE,
  con = dbc
)

# Retrieve all information on about 2,000 ongoing
# interventional cancer trials involving children
# into the same collection as used before
ctrLoadQueryIntoDb(
  queryterm = "cancer&recr=Open&type=Intr&age=0",
  register = "CTGOV",
  con = dbc
)

# Retrieve all information on more than 40 trials
# that are labelled as phase 3 and that mention
# either neuroblastoma or lymphoma from ISRCTN,
# into the same collection as used before
ctrLoadQueryIntoDb(
  queryterm = paste0(
    "https://www.isrctn.com/search?",
    "q=neuroblastoma+OR+lymphoma&filters=phase\%3APhase+III"),
  con = dbc
)

# Retrieve all information on completed trials in CTIS
ctrLoadQueryIntoDb(
  queryterm = "https://euclinicaltrials.eu/app/#/search?status=Ended",
  con = dbc
)
}

}
