% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{dbFindFields}
\alias{dbFindFields}
\title{Find names of fields in the database collection}
\usage{
dbFindFields(namepart = "", allmatches = FALSE, forceupdate = FALSE,
  debug = FALSE, collection = "ctrdata", db = "users",
  url = "mongodb://localhost", username = "", password = "",
  verbose = FALSE)
}
\arguments{
\item{namepart}{A plain string (not a regular expression) to be searched for
among all field names (keys) in the database.}

\item{allmatches}{If \code{TRUE}, returns all keys if more than one is found
(default is \code{FALSE}).}

\item{forceupdate}{If \code{TRUE}, refreshes collection of keys (default is
\code{FALSE}).}

\item{debug}{If \code{TRUE}, prints additional information (default is
\code{FALSE}).}

\item{collection}{Name of collection (default is "ctrdata")}

\item{db}{Name of database (default is "users")}

\item{url}{Address of the mongodb server in mongo connection string URI format
\url{http://docs.mongodb.org/manual/reference/connection-string/} (default is
mongodb://localhost)}

\item{username}{In case access requires credentials.}

\item{password}{In case access requires credentials.}

\item{verbose}{Print information.}
}
\value{
Vector of first field found (or all fields found, see above)
}
\description{
Given part of the name of a field of interest to the user, this function
returns the full field names as found in the database. It is not necessary to
add wild cards to the name of the field of interest.
}
\details{
For fields in EUCTR (protocol- and results-related information), see also the
register's documentation: \url{https://eudract.ema.europa.eu/}.

For fields in CTGOV (protocol-related information), see also the register's
definitions: \url{https://prsinfo.clinicaltrials.gov/definitions.html}

Note that generating a list of fields with variety.js as used in this function
may not work with certain mongo databases, for example when the host or port
is different per database, such as found with a free mongolab plan.
}
\examples{

\dontrun{
 dbFindFields("date")
}

}
