#'  Plot an lda.ct object
#'
#' Plots the Fisher's linear discriminant functions generated by a call
#' to \code{\link{lda.ct}}.
#'
#' @param x  linear discriminant analysis object produced by \code{\link{lda.ct}}
#' @param ylab,xlab  y- and x-axis labels
#' @param \dots  other arguments passed to \code{\link{matplot}}
#' @return  None; a plot is generated.
#' @author Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
#'
#' @seealso  \code{\link{lda.ct}}
#' @examples
#'
#' ## see the example at the end of ?pca.ct
#'
#'
#' @export plot.lda.ct
#' @export
plot.lda.ct <-
function(x, ylab="Discriminants", xlab="Time", ...) {
	fdobj <- x$fdobj
	grid <- seq(fdobj$basis$range[1], fdobj$basis$range[2], length = 401)
	matplot(grid, scale(eval.fd(grid,fdobj),T,F), type='l', lty=1, ylab=ylab, xlab=xlab, ...)
	legend("topleft", legend=paste0("LD", 1:x$nld), lty=1, col=1:x$nld)
	for (p in x$partition) abline(v=p, lty=2, col="grey")
	abline(h=0,col='grey')
}
