% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clinicaltrials_gov_download.R
\name{clinicaltrials_gov_download}
\alias{clinicaltrials_gov_download}
\title{Mass-download registry entry historical versions from
ClinicalTrials.gov}
\usage{
clinicaltrials_gov_download(nctids, output_filename)
}
\arguments{
\item{nctids}{A list of well-formed NCT numbers,
e.g. c("NCT00942747", "NCT03281616").}

\item{output_filename}{A character string for a filename into which
the dataframe will be written as a CSV,
e.g. "historical_versions.csv".}
}
\value{
On successful completion, returns TRUE, otherwise returns
FALSE. If the function is called again with the same NCT
numbers and output filename, it will check the output file for
errors in the download, remove them and try to download the
historical versions again.
}
\description{
Mass-download registry entry historical versions from
ClinicalTrials.gov
}
\examples{

\dontrun{
filename <- tempfile()
clinicaltrials_gov_download(c("NCT00942747",
    "NCT03281616"), filename)
}

}
