% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shoji-catalog.R
\name{catalogToDataFrame}
\alias{catalogToDataFrame}
\title{A utility to return a data.frame from a ShojiCatalog.}
\usage{
catalogToDataFrame(
  x,
  keys = TRUE,
  rownames = NULL,
  list_columns = c("subvariables", "subvariables_catalog"),
  ...
)
}
\arguments{
\item{x}{\code{ShojiCatalog} or subclass}

\item{keys}{character vector of attribute names from each catalog tuple to
include in the result. Default is TRUE, which means all.}

\item{rownames}{See \code{\link[base:data.frame]{base::data.frame()}} for the \code{row.names}
argument. The difference here is that if \code{rownames} is explicitly set as
\code{NULL}, the resulting object will not have row names set. By default, row
names will be the URLs of the catalog tuples.}

\item{list_columns}{A character vector of the names of the attributes that
should be stored in a list-column. Currently ignored.}

\item{...}{additional arguments passed to \code{data.frame}}
}
\value{
a \code{data.frame} view of the catalog
}
\description{
This is an internal function called by the various \code{as.data.frame} methods.
Use \code{as.data.frame} instead of calling this directly.
}
\details{
Some of the attributes of a \code{ShojiCatalog} will not naturally fit in
a conventional data.frame. For example, an array variable contains a list of
subvariables, and these subvariables will not easily fit in a single row of a
data.frame. In this case, the list of subvariables are stored in a
list-column in the resulting data.frame.
}
\keyword{internal}
