% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slides.R
\name{newSlide}
\alias{newSlide}
\title{Append a new slide to a Crunch Deck}
\usage{
newSlide(
  deck,
  query = NULL,
  display_settings = list(),
  title = "",
  subtitle = "",
  filter = NULL,
  weight = NULL,
  viz_specs = NULL,
  transform = NULL,
  ...
)
}
\arguments{
\item{deck}{A Crunch Deck}

\item{query}{A formula definition of a query to be used by the slide. See
Details of \code{\link[=crtabs]{crtabs()}} for more information about making queries.}

\item{display_settings}{(optional) A list of display settings. If omitted,
slide will be a table of column percentages with hypothesis test highlighting
enabled. The most common setting used is \code{vizType}, which can be:
\code{table}, \code{groupedBarPlot}, \code{stackedBarPlot}, \code{horizontalBarPlot},
\code{horizontalStackedBarPlot}, \code{donut}, and (if the second variable in the
query formula is a wave variable) \code{timeplot}.
In addition, \code{showValueLabels} (logical) controls whether the web app and
exports show labels on bars or arcs of donuts.}

\item{title}{The slide's title}

\item{subtitle}{The slide's subtitle}

\item{filter}{a \code{CrunchLogicalExpression}, a crunch \code{filter} object or
a vector of names of \code{\link{filters}} defined in the dataset (defaults
to \code{NULL}, using all data).}

\item{weight}{A weight variable (defaults to NULL, meaning no weight)}

\item{viz_specs}{Another set of options for the display of the slide, see
the \href{https://crunch.io/api/reference/#post-/datasets/-dataset_id-/decks/-deck_id-/slides/}{API documentation}
for more information.}

\item{transform}{A list of slide transformations, usually created using the function
\code{\link[=makeDimTransform]{makeDimTransform()}}.}

\item{...}{Further options to be passed on to the API}
}
\value{
CrunchSlide object
}
\description{
Append a new slide to a Crunch Deck
}
\examples{
\dontrun{
newSlide(
    main_deck,
    ~ cyl + wt,
    title = "Cyl and Weight",
    subtitle = "2017 Data"
)

# Grouped bar plot
newSlide(
    main_deck,
    ~ approval + age4,
    title = "Approval by age group",
    display_settings = list(
        vizType = "groupedBarPlot",
        showValueLabels = TRUE
    ),
    subtitle = "2017 Data"
)

# Horizontal stacked bars
newSlide(
    main_deck,
    ~ approval + age4,
    title = "Approval by age group",
    display_settings = list(
        vizType = "horizontalStackedBarPlot"
    ),
    subtitle = "2017 Data"
)

# A donut is only suitable for a single variable
newSlide(
    main_deck,
    ~ approval,
    title = "Approval of new feature",
    display_settings = list(
        vizType = "donut",
        showValueLabels = FALSE
    ),
    subtitle = "2017 Data"
)

# A Grouped bar plot with slide transformations to hide a category
newSlide(
    main_deck,
    ~ approval + age4,
    title = "Approval by age group",
    display_settings = list(
        vizType = "groupedBarPlot",
        showValueLabels = TRUE
    ),
    transform = list(rows_dimension = makeDimTransform(hide = "Neutral")),
    subtitle = "2017 Data"
)

# Example of advanced options being set:
# viz_specs can get quite long, see
# https://crunch.io/api/reference/#post-/datasets/-dataset_id-/decks/-deck_id-/slides/
viz_specs <- list(
    default = list(
        format = list(
            decimal_places = list(percentages = 0L, other = 2L),
            show_empty = FALSE
        )
    ),
    table = list(
        measures = c("col_percent", "pairwise_t_test"),
        page_layout = list(
            rows = list(
                top = list(),
                bottom = c("base_unweighted", "scale_mean", "significant_columns")
            ),
            measure_layout = "long"
        ),
        pairwise_comparison = list(sig_threshold = c(0.05, 0.01)),
        format = list(pval_colors = FALSE)
    )
)

newSlide(
    main_deck,
    ~categories(fav_array)+subvariables(fav_array),
    display_settings = list(viz_type = list(value = "table")),
    title = "custom slide",
    filter = filters(ds)[[1]],
    weight = ds$weight,
    viz_specs = viz_specs
)

# Can also specify `analyses` directly, which allows for very advanced use.
# `formulaToSlideQuery()` and `slideQueryEnv()` help describe the API
newSlide(
    main_deck,
    title = "custom slide",
    analyses = list(list(
        query = formulaToSlideQuery(~categories(fav_array)+subvariables(fav_array), ds),
        query_environment = slideQueryEnv(filter = filters(ds)[[1]]),
        display_settings = list(viz_type = list(value = "table")),
        viz_specs = viz_specs
    ))
)
}
}
