% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variable-as-methods.R
\name{variable-as-methods}
\alias{variable-as-methods}
\alias{as.Categorical}
\alias{as.Datetime}
\alias{as.Numeric}
\alias{as.Text}
\alias{as.Numeric,CrunchVariable-method}
\alias{as.Text,CrunchVariable-method}
\alias{as.Categorical,CrunchVariable-method}
\alias{as.Datetime,CrunchVariable-method}
\alias{as.double.CrunchVariable}
\alias{as.character.CrunchVariable}
\title{as.* methods for variables}
\usage{
\S4method{as.Numeric}{CrunchVariable}(x)

\S4method{as.Text}{CrunchVariable}(x, format)

\S4method{as.Categorical}{CrunchVariable}(x, format)

\S4method{as.Datetime}{CrunchVariable}(x, format = "\%Y-\%m-\%d \%H:\%M:\%S", resolution, offset)

\method{as.double}{CrunchVariable}(x, ...)

\method{as.character}{CrunchVariable}(x, ...)
}
\arguments{
\item{x}{a Crunch variable to derive and convert to a new type}

\item{format}{for \code{as.Datetime}, when the variable in \code{x} is a text or
categorical variable, \code{format} is the typographical format that the datetime
is already formatted in that needs to be parse from (default:
\code{"\%Y-\%m-\%d \%H:\%M:\%S"}); for \code{as.Text} and  \code{as.Categorical}, is
the typographical format that the datetime is to be formatted as (e.g.
\code{"\%Y-\%m-\%d \%H:\%M:\%S"} for "2018-01-08 12:39:57", the default if
no rollup resolution is specified on the source variable. If a rollup
resolution is specified, a reasonable default will be used.).}

\item{resolution}{for \code{as.Datetime}, when the variable in \code{x} is a numeric
variable, the resolution of the number (e.g. \code{"ms"} for milliseconds, \code{"s"}
for seconds, etc. see \link{expressions} for more information about valid values.)}

\item{offset}{for \code{as.Datetime}, when the variable in \code{x} is a numeric the, a
character of the offset to count from in the shape "2018-01-08 12:39:57". If
not supplied, Crunch's default of 1970-01-01 00:00:00 will be used.}

\item{...}{additional arguments for \code{as.character} and \code{as.numeric}, ignored when used with
Crunch variables}
}
\value{
a \code{VariableDefinition} to be used as the derivation
}
\description{
Use the as.* family of functions to make a derived copy of a variable that
has been converted into a new type.
}
\details{
Each type of Crunch variable (text, numeric, categorical, etc.) has an \verb{as.*}
function (\code{as.Text}, \code{as.Numeric}, and \code{as.Categorical} respectively) that
takes the input given as \code{x}, and makes a new derived variable that is now of
the type specified. See below for detailed examples.

For \code{as.Text} and \code{as.Numeric}, aliases to the R-native functions
\code{as.character} and \code{as.numeric} are provided for convenience.
}
\examples{
\dontrun{
# ds$v1 is of type Text
is.Text(ds$v1)
# [1] TRUE

# that has strings of numbers
as.vector(ds$v1)
# [1] "32"   "8"    "4096" "1024"

# convert this to a numeric variable with the alias `v1_numeric`
ds$v1_numeric <- as.Numeric(ds$v1)

# the values are the same, but are now numerics and the type is Numeric
as.vector(ds$v1_numeric)
# [1]   32    8 4096 1024
is.Numeric(ds$v1_numeric)
# [1] TRUE

# this new variable is derived, so if new data is appended or streamed, the
# new rows of data will be updated.
is.derived(ds$v1_numeric)
# [1] TRUE
}
}
