% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_cricsheet.R
\name{fetch_cricsheet}
\alias{fetch_cricsheet}
\title{Fetch ball-by-ball, match and player data from Cricsheet and return a tibble.}
\usage{
fetch_cricsheet(
  type = c("bbb", "match", "player"),
  gender = c("female", "male"),
  competition = c("tests", "multi_day", "odis", "odms", "t20is", "t20is_unofficial",
    "apl", "bbl", "bpl", "county", "edwards_cup", "cpl", "the_hundred", "ipl", "lpl",
    "msl", "t20_blast", "psl", "heyhoe_flint_trophy", "sheffield_shield", "super_smash",
    "wbbl", "wt20c")
)
}
\arguments{
\item{type}{Character string giving type of data: ball-by-ball, match info or player info.}

\item{gender}{Character string giving player gender: female or male.}

\item{competition}{Character string giving name of competition.}
}
\value{
A \code{tibble} object, similar to a \code{data.frame}.
}
\description{
Download csv data from Cricsheet \url{https://cricsheet.org/downloads/}.
Data must be specified by three factors:
(a) type of data: `bbb` (ball-by-ball), `match` or `player`.
(b) gender;
(c) competition.
See \url{https://cricsheet.org/downloads/} for what the competition character codes mean.
}
\examples{
\dontrun{
wbbl_bbb <- fetch_cricsheet(competition = "wbbl", type = "bbb")
wbbl_match <- fetch_cricsheet(competition = "wbbl", type = "match")
wbbl_player <- fetch_cricsheet(competition = "wbbl", type = "player")
}
}
\author{
Jacquie Tran and Rob J Hyndman
}
