.Random.seed <- c(403L, 384L, -967394618L, 1709091488L, 1266603870L,
                  -13935172L, 660557109L, -1663109970L, -1178344326L,
                  699630352L, 171653733L, -319169727L, 772080844L,
                  1949356353L, -1899752118L, 482546237L, 257913695L,
                  831730585L, -953432189L, 1249737158L, 1274443972L,
                  1950158078L, -120627182L, 1690626752L, 1956526297L,
                  1467427450L, -1462629215L, -892418869L, 1432646752L,
                  -2004820082L, 826943806L, 1352708302L, 428156570L,
                  -1364232089L, -580789716L, -339846685L, -108856741L,
                  -528281314L, -1865445510L, 1895361257L, 1998455729L,
                  1326789647L, -546899767L, 1545264886L, 2146791497L,
                  1635951535L, 420502751L, 1700366873L, -1276041555L,
                  -1048691049L, 1192234635L, 1854430513L, 1196880825L,
                  -743564622L, 1423248779L, -258309410L, -1896617111L,
                  1575893679L, -1804972195L, -956647654L, 710812089L,
                  -1435283663L, -1912517027L, 1853282135L, -1033512298L,
                  62266590L, -1704530216L, 1911024941L, 1954964497L,
                  1580596964L, -1599713683L, 2056857135L, -1279118424L,
                  1767200949L, -36654271L, 364098757L, 1874940984L,
                  1726476934L, 1446235547L, -941717143L, 195725762L,
                  151252310L, -2122623925L, -591702366L, -2102558928L,
                  -465653128L, 1535700845L, 1264889688L, -248832081L,
                  1938652501L, 2141365528L, 802633592L, -998054385L,
                  1133142520L, 829046173L, 1467147391L, 1533237696L,
                  1116597664L, 1694927825L, 2068821468L, -1307745018L,
                  1177500971L, 1712735319L, 934668339L, -740331802L,
                  -580640204L, -47141791L, -732655239L, 564720613L,
                  1093180617L, -564792972L, -1482057987L, 1603748774L,
                  418688357L, 22229534L, -812921821L, 289967714L,
                  1972090182L, 803481465L, 922303546L, -1256277488L,
                  -776284989L, 349994221L, 1130984906L, -1062158580L,
                  1605584954L, 1957122529L, -737621820L, 2054519807L,
                  -1346581363L, 256011758L, -432343192L, 757365678L,
                  1887621076L, -1824852160L, -65876858L, 595197835L,
                  -1946101245L, 1230690103L, 115736399L, -1952090599L,
                  -301342616L, -730075174L, -40778044L, 862613787L,
                  -22480388L, 433158814L, -48706377L, 347029536L,
                  1073265784L, 1386160726L, -316331221L, 694193714L,
                  438424479L, 418343338L, 977044889L, -820094820L,
                  -939143634L, 677519363L, 1180808019L, 354829968L,
                  109410980L, -1622982150L, 1522690000L, -132251388L,
                  73956493L, 1197051156L, -1652296810L, -2074500612L,
                  -417749853L, 1500860523L, 978198134L, -1692196408L,
                  -488871207L, -156023348L, -1437883636L, -669200794L,
                  1949197175L, 913346305L, -1635859768L, 1641168099L,
                  -764909817L, 2087859227L, 618653417L, 689529939L,
                  -1810292187L, 697885587L, 967693587L, 320967137L,
                  -826495697L, 2004172136L, -1148071744L, -2079856452L,
                  -1676484578L, -64478120L, 1373779486L, 243518854L,
                  1689960782L, -829009340L, -45661172L, 1456355930L,
                  -988417519L, -1128611189L, -1529022840L, -2090699782L,
                  -581545173L, -1268095253L, 1218503976L, -1870106142L,
                  -2018371904L, -1788502134L, -1203542698L, 1268454551L,
                  -1960648479L, -852881406L, -289985277L, -1064933337L,
                  -735676961L, 97879537L, 26848917L, 639408455L, 1865429265L,
                  -392336110L, -1335690176L, 1335889873L, -724341241L,
                  1884890232L, -1532276855L, 2102679068L, -1635089952L,
                  1115549199L, 132821068L, 1955171236L, -1084433356L,
                  -1931809697L, 483930542L, 719953030L, 518925168L,
                  1956933006L, 1150738003L, -1482924671L, -652143650L,
                  -1277605255L, 1120464076L, 2125426807L, 1496148226L,
                  -195797044L, 874622601L, 1154075199L, -1410992883L,
                  402675846L, -907339674L, -1643931283L, 445677170L,
                  -1756161449L, 943483428L, 1118936466L, -2056234225L,
                  491425535L, -549441804L, -1479212662L, 141848349L,
                  24202764L, -1441978766L, -63906106L, -1960270585L,
                  260784611L, -1889889362L, -1224314822L, 373328332L,
                  869106721L, -2095796459L, 1652206514L, 1042959326L,
                  980583209L, -390592444L, -239539311L, -1799653871L,
                  -749730133L, 1691738546L, -1450167472L, 1593321526L,
                  1639034877L, 960902777L, -1693700365L, -289342298L,
                  1773898136L, 435217101L, 207195528L, -1343251897L,
                  -2051775887L, 2125834487L, 1919665801L, 481011808L,
                  1719239528L, 1713365341L, -1454342816L, -837805971L,
                  -1677235566L, -1611532291L, -1491131666L, -872687139L,
                  -1798668475L, 543881347L, -958850644L, 1389438770L,
                  1121345294L, 737205877L, 34473324L, -641750428L,
                  -1379206536L, 693423561L, -514820958L, 341904494L,
                  168416033L, 1195625744L, -737414096L, 1517584969L,
                  1964923100L, 396952062L, -1108898571L, -192437261L,
                  601481708L, -1776958834L, -215626879L, 447408024L,
                  327924478L, -789288889L, -1316356846L, -1005462515L,
                  -1610466717L, 320146186L, -2132157606L, 770621468L,
                  -421092179L, 1054470634L, 549657118L, 1001946448L,
                  -1628548675L, 1332290037L, -526166648L, 708952542L,
                  -1060038288L, 1750602236L, -1602225130L, -1823857291L,
                  -1532025139L, 1871311726L, -1723568372L, 2069407145L,
                  -795695709L, 226778049L, -1609687576L, 448963632L,
                  -1257584286L, -272582811L, 1103558377L, 574441685L,
                  -689234446L, 620897379L, 599380388L, -1293775720L,
                  419076400L, 1015560217L, 2019834101L, 659159710L,
                  1124291607L, -1233874187L, 1599102032L, 1991165203L,
                  -167652540L, -702199747L, -1492456175L, 24154420L,
                  -1470555840L, 825993762L, 1266739770L, 1363386740L,
                  -1290624800L, -929586242L, -521611689L, 436457447L,
                  -1240371605L, -854582132L, -378633489L, 345784549L,
                  2053226236L, 1772801800L, 403187880L, 1150400352L,
                  -1402326900L, 1963156517L, -1019433454L, -88363695L,
                  -2124734329L, 1806099212L, -1377258084L, -1455815605L,
                  822500057L, 1540870430L, -2145091343L, 1815863263L,
                  -1653124381L, 2079177415L, -1466007549L, -825301126L,
                  1117287593L, 896952610L, -1554475361L, 595979691L,
                  -1231254110L, -1794784388L, 725665781L, 1748403953L,
                  940358216L, 1180339566L, 144484495L, 182029826L,
                  -1722870645L, -1969710199L, 306990396L, -1243245863L,
                  239854818L, 2054550550L, 1589108031L, -351391372L,
                  1593580915L, 1924773519L, 630701546L, -1392927228L,
                  1321085973L, -616318807L, 1409808966L, 677388582L,
                  923324459L, 1547142041L, -479418099L, 1598571901L,
                  1183875813L, 1860395769L, -766678601L, 1595073778L,
                  796199355L, -1426909789L, 170016639L, -1173668916L,
                  1576118181L, -784464838L, 958790276L, 603307647L,
                  1004484059L, 906904403L, -1097260923L, 149323670L,
                  1455973358L, 594566110L, -1989718920L, 1480276217L,
                  218188585L, 731144657L, 183415455L, 551331125L,
                  -399128188L, 787061985L, -673399365L, -1066651551L,
                  -453641149L, 1725282512L, 990185496L, 383639658L,
                  2028936409L, -1811806258L, 954584633L, -1648063660L,
                  -1078377877L, -2038022890L, -612144395L, 767398447L,
                  2050797062L, 2050224029L, -631163765L, 1853575295L,
                  1302150713L, 2134432901L, -925621645L, -1624258024L,
                  927752513L, -2012215670L, -156805617L, -1438176955L,
                  -1653115499L, -1042665446L, 392638750L, -1122063L,
                  -2121773881L, -583051033L, 1131949993L, 465225911L,
                  1698771881L, -1598664369L, 812040800L, -1161895088L,
                  1846361995L, -1706985266L, 1497453364L, -2027369741L,
                  -1799507128L, 518578561L, -1566080050L, 1957518946L,
                  -1390496041L, 1755553365L, -1236055586L, 536487702L,
                  1695738849L, -771485332L, 1749539601L, 1659461028L,
                  -1161707888L, 383960624L, -502031820L, -1738750589L,
                  -1091965691L, 987663828L, 309423046L, -1587500988L,
                  41069950L, -190835334L, -1284574029L, -1082213901L,
                  1200712374L, -2131729607L, -865999875L, -2145387404L,
                  -135124699L, 928390763L, -1167972717L, 1501110723L,
                  1969997232L, -676432020L, -1317164463L, -643610005L,
                  -1786504153L, -1410539557L, -479009070L, 436928248L,
                  -179483302L, 804879860L, 305887422L, 123693310L,
                  2000450976L, 488919745L, 1314066475L, -1958057631L,
                  -1140736384L, -185092414L, 728473856L, -68154957L,
                  -66199559L, -2118833802L, 1950144525L, 1952132384L,
                  -766090258L, -706632785L, 1280161870L, 1560615322L,
                  -421654400L, -151891080L, 1854735899L, -968402642L,
                  -1415351889L, -1678889905L, 62159130L, -851262033L,
                  -524504211L, -1303002759L, -1242428487L, -77701660L,
                  -352006573L, 1026900423L, -926155216L, -2121254010L,
                  -323866820L, -625232450L, -1092274430L, 1905474366L,
                  -2055558807L, 711952129L, 1624530052L, -1037216255L,
                  362468085L, -1990052591L, -228797527L, 688242136L,
                  2014455169L, -1577527066L, 258178602L, 762081203L,
                  1604970315L, -298898822L, 1872642008L, -950803229L,
                  228027251L, -16574806L, -6967132L, -828630018L,
                  -1880636446L, -1455705706L, 1351541178L, 903768789L,
                  -1568006699L, 167203682L, 1599633483L, -1024472426L,
                  -698969170L, -1437928171L, -1156402799L, 1122493543L,
                  -607411559L, 55417736L, 1993198746L, 929142911L,
                  70336915L, -991939639L, -1545046851L, 304940986L)
                  
rmvtt <- function(mu, Sigma, df=Inf, lower, upper){
	p <- length(mu)
	out <- rep(NA,p)
	div <- ifelse(df==Inf, 1, sqrt(rchisq(1,df=df)/df))
	truncLo <- pnorm(div*(lower[1]-mu[1])/sqrt(Sigma[1,1]))
	truncUp <- pnorm((div*upper[1]-mu[1])/sqrt(Sigma[1,1]))
	out[1] <- mu[1] + sqrt(Sigma[1,1])*(qnorm(runif(1, truncLo, truncUp))/div)
	if(p>1){	
		for(i in 2:p){
			S12 <- Sigma[i,1:(i-1)]
			S22 <- Sigma[1:(i-1),1:(i-1)]
			res <- out[1:(i-1)]-mu[1:(i-1)]
			mu.c <- mu[i] + S12%*%solve(S22, res)
			S.c <- Sigma[i,i] - S12%*%solve(S22,S12)
			truncLo <- pnorm(div*(lower[i]-mu.c)/sqrt(S.c))
			truncUp <- pnorm((div*upper[i]-mu.c)/sqrt(S.c))
			out[i] <- mu.c + sqrt(S.c)*(qnorm(runif(1, truncLo, truncUp))/div)
		}
		return(out)
	}
	else return(out)
}

getSD <- function(x){
	d <- as.numeric(sapply(strsplit(as.character(x),"e-"), function(x) x[2]))
	if(any(!is.na(d))) return(max(d, na.rm=TRUE))
	else return(0)
}

# dmvslash <- function(x, mu, Sigma, q, log.p=FALSE){
# 	p <- length(x)
# 	if(missing(mu)) mu <- rep(0,p)
# 	if(missing(Sigma)) Sigma <- diag(rep(1,p))
# 	if(all(x==0)) out <- (q/(q+p))*(1/(2*pi))^(p/2)
# 	else{
# 		z <- sqrt(t(x-mu)%*%solve(Sigma, (x-mu)))
# 		a <- (q+p)/2
# 		integral <- integrate(f=function(t,a){t^(a-1) * exp(-t)}, a=a, lower=0, upper=z^2/2)$value
# 		out <- (q * 2^((q+p)/2 - 1) * integral)/((2*pi)^(p/2) * z^(q+p))
# 	}
# 	if(log.p) return(log(out))
# 	else return(out)
# }


# rmvtslash <- function(mu, Sigma, q=Inf, lower, upper){
# 	p <- length(mu)
# 	if(length(lower)!=p | length(upper)!=p) stop("\nLimits are not the correct size\n")
# 	out <- rep(NA,p)
# 	div <- ifelse(q==Inf, 1, runif(1,0,1)^(1/q))
# 	truncLo <- pnorm(div*(lower[1]-mu[1])/sqrt(Sigma[1,1]))
# 	truncUp <- pnorm((div*upper[1]-mu[1])/sqrt(Sigma[1,1]))
# 	out[1] <- mu[1] + sqrt(Sigma[1,1])*(qnorm(runif(1, truncLo, truncUp))/div)
# 	if(p>1){	
# 		for(i in 2:p){
# 			S12 <- Sigma[i,1:(i-1)]
# 			S22 <- Sigma[1:(i-1),1:(i-1)]
# 			res <- out[1:(i-1)]-mu[1:(i-1)]
# 			mu.c <- mu[i] + S12%*%solve(S22, res)
# 			S.c <- Sigma[i,i] - S12%*%solve(S22,S12)
# 			truncLo <- pnorm(div*(lower[i]-mu.c)/sqrt(S.c))
# 			truncUp <- pnorm((div*upper[i]-mu.c)/sqrt(S.c))
# 			out[i] <- mu.c + sqrt(S.c)*(qnorm(runif(1, truncLo, truncUp))/div)
# 		}
# 		return(out)
# 	}
# 	else return(out)
# }

