% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/long_run_var_est_kendall_H0.R
\name{long_run_var_est_kendall_H0}
\alias{long_run_var_est_kendall_H0}
\title{Estimator of long-run variance for Kendall's Tau}
\usage{
long_run_var_est_kendall_H0(x, y,
           kernelf=function(z) {return(ifelse(abs(z) <= 1,(1 - z^2)^2, 0))},
           bwf=function(nnn){3*nnn^(1/4)})
}
\arguments{
\item{x}{numeric input vector.}

\item{y}{numeric input vector.}

\item{kernelf}{kernel-function that should be used in the estimation procedure.}

\item{bwf}{function for choosing the bandwidth based on the sample size that is used in the estimation procedure.}
}
\value{
Estimate of long-run variance of estimator.
}
\description{
Estimates the long-run variance of the estimator of Kendall's Tau between short-range dependent observations
of independent random variables. The expression comes from the asymptotic normal distribution of estimator, see Corollary 2 in Lun et al. (2022).
}
\examples{
long_run_var_est_kendall_H0(x=rnorm(50),y=rnorm(50))
}
\references{
D. Lun, S. Fischer, A. Viglione, and G. Blöschl, Significance testing of rank cross-correlations between autocorrelated time series with short-range dependence, submitted to Journal of Applied Statistics, 2022.
}
\keyword{internal}
