% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{moments}
\alias{moments}
\alias{moments.mdpolya_result}
\alias{moments.grideval_result}
\title{Moment calculation generic function}
\usage{
moments(obj, mom, cntrl = TRUE, grd = NULL)

\method{moments}{mdpolya_result}(obj, mom, cntrl = TRUE, grd = NULL)

\method{moments}{grideval_result}(obj, mom, cntrl = TRUE, grd = NULL)
}
\arguments{
\item{obj}{The object for which a moment will be calculated.}

\item{mom}{A numeric scalar indicating the moment to calculate.}

\item{cntrl}{A logical value indicating whether the moment should be central
or not. Defaults to \code{TRUE}.}

\item{grd}{A numeric vector of grid values on which the density function
samples in `obj` should be calculated for trapezoidal integration.}
}
\value{
A vector of moment values for each sampled distribution in
  \code{obj}.
}
\description{
Moment calculation generic function
}
\section{Methods (by class)}{
\itemize{
\item \code{moments(mdpolya_result)}: Moment calculation method for \code{mdpolya_result}
objects.

\item \code{moments(grideval_result)}: Moment calculation method for \code{grideval_result}
objects.

}}
