% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at.R
\name{at}
\alias{at}
\alias{at.Container}
\alias{at.dict.table}
\title{Extract Elements Safely}
\usage{
at(.x, ...)

\method{at}{Container}(.x, ...)

\method{at}{dict.table}(.x, ...)
}
\arguments{
\item{.x}{an \code{R} object of the respective class.}

\item{...}{indices of elements to be extracted}
}
\value{
For \code{Container}, returns the values at the given indidces.

For \code{dict.table}, returns the columns at the given indices.
}
\description{
Extract parts of a Container at given indices. If an index is invalid, an
error is signaled. If given as a string, the element matching the
name is returned. If there are two or more identical names, the value of the
first match (i.e. \emph{leftmost} element) is returned. Indices can be letters or
numbers, or both at the same time.
}
\examples{

# Container
co = container(a = 1, 2, b = 3, 4)
at(co, 1:3)
at(co, "a", "b", 2)
\dontrun{
at(co, "x")     # index 'x' not found
at(co, 1:10)    # index 5 exceeds length of Container
}
# Dict
d = dict(a = 1, b = 3)
at(d, 1:2)
at(d, "a", 2)
\dontrun{
at(d, "x")     # index 'x' not found
at(d, 1:3)     # index 5 exceeds length of Dict
}

# dict.table
dit = dict.table(a = 1:3, b = 4:6)
at(dit, "a")
at(dit, 2)
at(dit, "a", 2)
\dontrun{
at(dit, "x")     # index 'x' not found
at(dit, 1:3)     # index 3 exceeds length of dict.table
}
}
\seealso{
\code{\link[=peek_at]{peek_at()}} for less strict extraction
}
