% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_pipeline.R
\name{run_pipeline}
\alias{run_pipeline}
\title{Runs user-provided pipeline for each row of arguments in parameters, converting any JSON
strings to objects}
\usage{
run_pipeline(pipeline, parameters)
}
\arguments{
\item{pipeline}{User-provided function with one argument, a dataframe}

\item{parameters}{An dataframe of fields to convert to json}
}
\description{
Runs user-provided pipeline for each row of arguments in parameters, converting any JSON
strings to objects
}
\examples{

library(whisker)

run_pipeline(
  function(params){
   query <- "SELECT result FROM {{table_prefix}}_results;"
   whisker.render(query,params)
 },
 data.frame(
   table_prefix = c('batman', 'robin')
 )
)

}
