% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_basename_vis.R
\name{get_basename_vis}
\alias{get_basename_vis}
\title{Determine the basename of a NetCDF file}
\usage{
get_basename_vis(infile, nc = NULL)
}
\arguments{
\item{infile}{Filename of input NetCDF file. This may include the directory
(character).}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\value{
A character string giving the basename.
}
\description{
This function determines the basename of either a file/URL path or an 'nc'
object (using nc$filename).
}
\details{
When the origin of the file path is a local .nc file then
\code{get_basename_vis()} is equivalent to \code{base::basename()}.

\code{get_basename_vis()} also handles the case of \code{infile}/\code{nc}
originating from a URL.

The value of \code{get_basename_vis()} always ends in ".nc".

If both \code{infile} and \code{nc} are specified, \code{infile} is ignored.
}
