% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/clttools.R
\name{coin.simu.plot}
\alias{coin.simu.plot}
\title{Probability Distribution Plot of Simulated Coins Flipping}
\usage{
coin.simu.plot(n, times, prob = NULL, qqplot = FALSE, col = "black", type = NULL,
main = NULL, sub = NULL)
}
\arguments{
\item{n}{number of trials in one simulation}

\item{times}{number of simulations}

\item{prob}{probability assigned to each possible outcome}

\item{qqplot}{an argument to output Q-Q plot or not, can be TRUE or FALSE}

\item{col}{color of the plot}

\item{type}{type of plot}

\item{main}{an overall title for the plot}

\item{sub}{a sub title for the plot}
}
\value{
Plot of mean value and corresponding probabilities for all simulated outcomes.
}
\description{
Probability plot of simulated experiments on flipping coins
}
\details{
The default probabilty equals to 1/n. All the assigned probabilites must between 0 and 1.
}
\examples{
coin.simu.plot(n = 4, times = 1000, col = 'red')
coin.simu.plot(4, 1000, prob = c(0.3, 0.7), type = 'p')
}

