% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_project_config.R
\name{cja_get_project_config}
\alias{cja_get_project_config}
\title{Get a project configuration in CJA}
\usage{
cja_get_project_config(
  id = NULL,
  expansion = "definition",
  locale = "en_US",
  debug = FALSE
)
}
\arguments{
\item{id}{(Required) The Project id for which to retrieve information}

\item{expansion}{Comma-delimited list of additional segment metadata fields to include on response. See Details for all options available}

\item{locale}{Locale - Default: "en_US"}

\item{debug}{Used to help troubleshoot api call issues. Shows the call and result in the console}
}
\value{
A project configuration list
}
\description{
Retrieves a project configuration JSON string.
}
\details{
\emph{expansion} options can include any of the following:
"shares" "tags" "accessLevel" "modified" "externalReferences" "definition"
}
\examples{
\dontrun{
cja_get_project_config(id = '6047e0a3de6aaaaac7c3accb')
}
}
