% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_annotations.R
\name{cja_get_annotations}
\alias{cja_get_annotations}
\title{Get list of annotations}
\usage{
cja_get_annotations(
  id = NULL,
  expansion = NULL,
  includeType = "all",
  locale = "en_US",
  filterByModifiedAfter = NULL,
  filterByDateRange = NULL,
  limit = 10,
  page = 0,
  debug = FALSE
)
}
\arguments{
\item{id}{Filter the results to one specific annotation by the annotation id. If not used, a list of annotations will be returned limited by the 'limit' and 'page' arguments.}

\item{expansion}{Obtain additional information around an annotation. You can include multiple expansions using the 'c()' function. See details for options.}

\item{includeType}{Include additional segments not owned by the user. Available values are \code{all} (default) and
\code{shared}. The \code{all} option takes precedence over "shared".}

\item{locale}{A query string that returns strings localized by Adobe into the desired language. Localization does not apply to user-defined fields, such as annotation names.
See details for options.}

\item{filterByModifiedAfter}{An ISO 8601 date that returns only annotations that were modified after the desired date. example datetime format: 'YYYY-MM-DDTHH:MM:SSZ'}

\item{filterByDateRange}{Two ISO 8601 dates separated by a forward slash (/) that returns only annotations that fully reside within the desired date range. example format: 'MM:SSZ/YYYY-MM-DDTHH:MM:SSZ'}

\item{limit}{An integer that represents the number of results per page. Default is 10}

\item{page}{An integer that represents which page to return results. The first page is 0. The API supports up to 1000 pages}

\item{debug}{Include the output and input of the api call in the console for debugging. Default is FALSE}
}
\value{
A data frame of segments and their meta data.
}
\description{
Retrieve all annotations or filter to return only one
}
\details{
\itemize{
\item Expansion options include the following:
\itemize{
\item \strong{name:} The name of the annotation.
\item \strong{description} The annotation's description.
\item \strong{dateRange} The date range of the annotation.
\item \strong{color:} An enum representing the annotation's color. Supported values include STANDARD1 through STANDARD9. These correspond with 'blue', 'purple', 'green', 'orange', 'red', 'light green', 'pink', 'dark green', and 'yellow', in that order.
\item \strong{applyToAllReports:} A boolean that determines if the annotation applies to all report suites.
\item \strong{scope:} An object including the metrics and filters that the annotation uses.
\item \strong{createdDate:} The date that the annotation was created.
\item \strong{modifiedDate:} The date that the annotation was last modified.
\item \strong{modifiedById:} The ID of the user who last modified the annotation.
\item \strong{tags:} The tags applied to the annotation.
\item \strong{shares:} The shares applied to the annotation.
\item \strong{approved:} A boolean that determines if the annotation is approved by an admin.
\item \strong{favorite:} A boolean that determines if the user has this annotation favorited (starred).
\item \strong{usageSummary:} An object that shows where this annotation is used.
\item \strong{owner:} An object showing the ID, name, and login of the user that created the annotation.
\item \strong{imsOrgId:} The IMS org of the annotation.
\item \strong{dataName:} The Data View name.
\item \strong{dataId:} The Data View ID.
}
\item Locale options include the following:
\itemize{
\item \strong{en_US:} English
\item \strong{fr_FR:} French
\item \strong{ja_JP:} Japanese
\item \strong{de_DE:} German
\item \strong{es_ES:} Spanish
\item \strong{ko_KR:} Korean
\item \strong{pt_PR:} Brazilian Portuguese
\item \strong{zh_CN:} Simplified Chinese
\item \strong{zh_TW:} Traditional Chinese
}
}
}
