% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{users_post}
\alias{users_post}
\title{Create a new user (must be a team or org admin)}
\usage{
users_post(
  name,
  email,
  primary_group_id,
  user,
  active = NULL,
  city = NULL,
  state = NULL,
  time_zone = NULL,
  initials = NULL,
  department = NULL,
  title = NULL,
  prefers_sms_otp = NULL,
  group_ids = NULL,
  vpn_enabled = NULL,
  sso_disabled = NULL,
  otp_required_for_login = NULL,
  exempt_from_org_sms_otp_disabled = NULL,
  robot = NULL,
  send_email = NULL
)
}
\arguments{
\item{name}{string required. The name of this user.}

\item{email}{string required. The email of this user.}

\item{primary_group_id}{integer required. The ID of the primary group of this user.}

\item{user}{string required. The username of this user.}

\item{active}{boolean optional. Whether this user account is active or deactivated.}

\item{city}{string optional. The city of this user.}

\item{state}{string optional. The state of this user.}

\item{time_zone}{string optional. The time zone of this user.}

\item{initials}{string optional. The initials of this user.}

\item{department}{string optional. The department of this user.}

\item{title}{string optional. The title of this user.}

\item{prefers_sms_otp}{boolean optional. The preference for phone authorization of this user}

\item{group_ids}{array optional. An array of ids of all the groups this user is in.}

\item{vpn_enabled}{boolean optional. The availability of vpn for this user.}

\item{sso_disabled}{boolean optional. The availability of SSO for this user.}

\item{otp_required_for_login}{boolean optional. The two factor authentication requirement for this user.}

\item{exempt_from_org_sms_otp_disabled}{boolean optional. Whether the user has SMS OTP enabled on an individual level. This field does not matter if the org does not have SMS OTP disabled.}

\item{robot}{boolean optional. Whether the user is a robot.}

\item{send_email}{boolean optional. Whether the user will receive a welcome email.}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID of this user.}
\item{user}{string, The username of this user.}
\item{name}{string, The name of this user.}
\item{email}{string, The email of this user.}
\item{active}{boolean, Whether this user account is active or deactivated.}
\item{primaryGroupId}{integer, The ID of the primary group of this user.}
\item{groups}{array, An array containing the following fields: 
\itemize{
\item id integer, The ID of this group.
\item name string, The name of this group.
\item slug string, The slug of this group.
\item organizationId integer, The ID of the organization associated with this group.
\item organizationName string, The name of the organization associated with this group.
}}
\item{city}{string, The city of this user.}
\item{state}{string, The state of this user.}
\item{timeZone}{string, The time zone of this user.}
\item{initials}{string, The initials of this user.}
\item{department}{string, The department of this user.}
\item{title}{string, The title of this user.}
\item{githubUsername}{string, The GitHub username of this user.}
\item{prefersSmsOtp}{boolean, The preference for phone authorization of this user}
\item{vpnEnabled}{boolean, The availability of vpn for this user.}
\item{ssoDisabled}{boolean, The availability of SSO for this user.}
\item{otpRequiredForLogin}{boolean, The two factor authentication requirement for this user.}
\item{exemptFromOrgSmsOtpDisabled}{boolean, Whether the user has SMS OTP enabled on an individual level. This field does not matter if the org does not have SMS OTP disabled.}
\item{smsOtpAllowed}{boolean, Whether the user is allowed to receive two factor authentication codes via SMS.}
\item{robot}{boolean, Whether the user is a robot.}
\item{phone}{string, The phone number of this user.}
\item{organizationSlug}{string, The slug of the organization the user belongs to.}
\item{organizationSSODisableCapable}{boolean, The user's organization's ability to disable sso for their users.}
\item{organizationLoginType}{string, The user's organization's login type.}
\item{organizationSmsOtpDisabled}{boolean, Whether the user's organization has SMS OTP disabled.}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{createdAt}{string, The date and time when the user was created.}
\item{updatedAt}{string, The date and time when the user was last updated.}
\item{lastSeenAt}{string, The date and time when the user last visited Platform.}
\item{suspended}{boolean, Whether the user is suspended due to inactivity.}
\item{createdById}{integer, The ID of the user who created this user.}
\item{lastUpdatedById}{integer, The ID of the user who last updated this user.}
\item{unconfirmedEmail}{string, The new email address awaiting confirmation from the user.}
\item{accountStatus}{string, Account status of this user. One of: "Active", "Deactivated", "Suspended", "Unsuspended"}
}
\description{
Create a new user (must be a team or org admin)
}
