% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/civis_ml.R
\name{fetch_predictions}
\alias{fetch_predictions}
\title{Retrieve predictions from a CivisML prediction job}
\usage{
fetch_predictions(x, ...)
}
\arguments{
\item{x}{\code{civis_ml_prediction} object from \code{predict.civis_ml}}

\item{...}{arguments passed to \code{read.csv}}
}
\value{
A \code{data.frame} of predictions containing an additional column with
 a primary key. For a multiclass model, a data frame is returned with one
  column of predictions for each class.
}
\description{
Retrieve predictions from a CivisML prediction job
}
\details{
Predictions can also be downloaded as a \code{csv} directly using \code{download_civis} (see examples).
}
\examples{
\dontrun{
m <- civis_ml("path/to/file.csv", model_type = "sparse_logistic",
  dependent_variable = "Species")
pred_job <- predict(m, newdata = "path/to/newdata.csv")
yhat <- fetch_predictions(pred_job)

# download instead:
download_civis(pred_job$model_info$output_file_ids, path = "my_predictions.csv")

}
}
