% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mht01.R
\docType{data}
\name{mht01_label}
\alias{mht01_label}
\alias{mht01_main}
\alias{mht01_pre}
\alias{mht01_post}
\alias{mht01}
\title{\code{MHT01} Medical History Table.}
\format{
An object of class \code{character} of length 2.

An object of class \code{chevron_t} of length 1.
}
\usage{
mht01_label

mht01_main(
  adam_db,
  arm_var = "ARM",
  row_split_var = "MHBODSYS",
  lbl_overall = NULL,
  summary_labels = list(all = mht01_label),
  ...
)

mht01_pre(adam_db, ...)

mht01_post(tlg, prune_0 = TRUE, ...)

mht01
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frames}) object containing the \code{ADaM} datasets}

\item{arm_var}{(\code{string}) variable used for column splitting}

\item{row_split_var}{(\code{character}) additional row split variables.}

\item{lbl_overall}{(\code{string}) label used for overall column, if set to \code{NULL} the overall column is omitted}

\item{summary_labels}{(\code{list}) of summarize labels. See details.}

\item{...}{not used.}

\item{tlg}{(\code{TableTree}, \code{Listing} or \code{ggplot}) object typically produced by a \code{main} function.}

\item{prune_0}{(\code{flag}) remove 0 count rows}
}
\value{
the main function returns an \code{rtables} object.

the preprocessing function returns a \code{list} of \code{data.frame}.

the postprocessing function returns an \code{rtables} object or an \code{ElementaryTable} (null report).
}
\description{
The \code{MHT01} table provides an overview of the subjects medical
history by SOC and Preferred Term.
}
\details{
\itemize{
\item Numbers represent absolute numbers of patients and fraction of \code{N}, or absolute number of event when specified.
\item Remove zero-count rows unless overridden with \code{prune_0 = FALSE}.
\item Split columns by arm.
\item Does not include a total column by default.
\item Order by body system alphabetically and within body system and medical condition by decreasing total number of
patients with the specific condition.
\code{summary_labels} is used to control the summary for each level. If "all" is used, then each split will have that
summary statistic with the labels. One special case is "TOTAL", this is for the overall population.
}
}
\section{Functions}{
\itemize{
\item \code{mht01_label}: Default labels

\item \code{mht01_main()}: Main TLG function

\item \code{mht01_pre()}: Preprocessing

\item \code{mht01_post()}: Postprocessing

}}
\note{
\itemize{
\item \code{adam_db} object must contain an \code{admh} table with columns \code{"MHBODSYS"} and \code{"MHDECOD"}.
}
}
\examples{
run(mht01, syn_data)
}
\keyword{datasets}
