% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkNamed.r
\name{checkNamed}
\alias{assertNamed}
\alias{assert_named}
\alias{checkNamed}
\alias{testNamed}
\alias{test_named}
\title{Check if an argument is named}
\usage{
checkNamed(x, type = "named")

assertNamed(x, type = "named", add = NULL, .var.name = NULL)

assert_named(x, type = "named", add = NULL, .var.name = NULL)

testNamed(x, type = "named")

test_named(x, type = "named")
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{type}{[character(1)]\cr
Select the check(s) to perform.
\dQuote{unnamed} checks \code{x} to be unnamed.
\dQuote{named} (default) checks \code{x} to be named which excludes names to be \code{NA} or empty (\code{""}).
\dQuote{unique} additionally tests for non-duplicated names.
\dQuote{strict} checks for unique names which comply to R's variable name restrictions.
Note that for zero-length \code{x} every name check evaluates to \code{TRUE}.
Also note that you can use \code{\link{checkSubset}} to check for a specific set of names.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertions. See \code{\link{AssertCollection}}.}

\item{.var.name}{[\code{NULL} || \code{character(1)}]\cr
Name of the checked object to print in error message. If \code{NULL},
the name will be heuristically determined via \code{\link[base]{substitute}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions return \code{TRUE}. If the check
 is not successful, \code{assertNamed}/\code{assert_named}
 throws an error message, \code{testNamed}/\code{test_named}
 returns \code{FALSE},
 and \code{checkNamed} returns a string with the error message.
 The function \code{expect_named} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an argument is named
}
\examples{
x = 1:3
testNamed(x, "unnamed")
names(x) = letters[1:3]
testNamed(x, "unique")
}

