% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slow_print_v2.R
\name{slow_print_v2}
\alias{slow_print_v2}
\title{Slowly Print Text}
\usage{
slow_print_v2(text, random = FALSE, delay = 0.125)
}
\arguments{
\item{text}{A string representing the text to be printed. Must be a non-NA string.}

\item{random}{A logical value indicating whether the delay between characters should be random.
Default is FALSE.}

\item{delay}{A numeric value representing the fixed delay between characters in seconds.
Default is 0.125. Must be a non-negative number.}
}
\value{
Invisible NULL. The function prints the text to the console.
}
\description{
Prints the characters of the input text string one by one,
   with a specified delay between each character. If the random parameter
   is set to TRUE, the delay will be a random value between 0.0001 and 0.3 seconds.
   Otherwise, the delay will be the value specified by the delay parameter.
}
\details{
Slowly Print Text

This function prints the characters of a given text string one by one,
with a specified delay between each character. The delay can be either fixed or random.
}
\examples{
\dontrun{
slow_print_v2("Hello, World!")
slow_print_v2("Hello, World!", random = TRUE)
slow_print_v2("Hello, World!", delay = 0.1)
}
}
\author{
Satoshi Kume
}
