\name{tree}

\alias{tree}

\title{Specify a Tree-Ordering in a CGAM Formula}

\description{A symbolic routine to define that the systematic component \eqn{\eta} has a tree-ordering in a predictor in a formula argument to cgam.}

\usage{tree(x, pl = NULL)}

\arguments{
  \item{x}{A numeric vector which has the same length as the response vector. Note that the placebo level of x must be 0.}
  \item{pl}{The placebo level.}
}

\value{The vector x with two attributes, i.e., name: the name of x; shape: "tree".}

\details{
  "tree" returns the vector "x" and imposes on it two attributes: name and shape. 

  The name attribute is used in the subroutine plotpersp; the shape attribute is "tree", and according to the value of the vector itself and its shape attribute, the cone edges of the cone generated by the constraint matrix, which constrains that \eqn{\eta} has a tree-ordering in "x"  will be made. The cone edges are a set of basis employed in the hinge algorithm. 

  Note that "tree" does not make the corresponding cone edges itself. It sets things up to a sub-routine called tree.fun in cgam which will make the cone edges. A tree-ordering is a partial ordering: For a categorical variable \eqn{x}, if there are treatment levels \eqn{x_1,\ldots,x_k}, where \eqn{x_1} is a placebo, we compare \eqn{x_i, i = 2,\ldots,k} with \eqn{x_1}, and not have any other comparable pairs.

  See references cited in this section for more details.
}

\author{
  Mary C. Meyer and Xiyue Liao
}

\references{
   Meyer, M. C. (2013b) A simple new algorithm for quadratic programming with applications in statistics. \emph{Communications in Statistics \bold{42(5)}}, 1126--1139. 
}

\examples{
  # generate y
  set.seed(123)
  n <- 100 
  x <- rep(0:4, each = 20)
  z <- rep(c("a", "b"), 50)
  y <- x + I(z == "a") + rnorm(n, 1)
  xu <- unique(x)

  # regress y on x under the tree-ordering restriction
  fit.tree <- cgam(y ~ tree(x) + factor(z)) 

  # make a plot
  plot(x, y, cex = .7)
  mua = unique(fit.tree$muhat)[unique(z) == "a"]
  points(xu, unique(fit.tree$muhat)[unique(z) == "a"], pch = '+', col = 4, cex = 3)
  legend(0,7.5, bty = "n", "tree-ordering fit: z = 'a'", col = 4, pch = '+', cex = 1.3)
  mub = unique(fit.tree$muhat)[unique(z) == "b"] 
  points(xu, unique(fit.tree$muhat)[unique(z) == "b"], pch = '+', col = 2, cex = 3)
  legend(0,8.5, bty = "n", "tree-ordering fit: z = 'b'", col = 2, pch = '+', cex = 1.3)
}

\seealso{
  \code{\link{umbrella}}
}

\keyword{shape routine}
