% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_stats.R
\name{cfbd_stats_season_advanced}
\alias{cfbd_stats_season_advanced}
\title{\strong{Get season advanced statistics by team}}
\usage{
cfbd_stats_season_advanced(
  year,
  team = NULL,
  excl_garbage_time = FALSE,
  start_week = NULL,
  end_week = NULL
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{team}{(\emph{String} optional): D-I Team}

\item{excl_garbage_time}{(\emph{Logical} default FALSE): Select whether to exclude Garbage Time (TRUE/FALSE)}

\item{start_week}{(\emph{Integer} optional): Starting Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}

\item{end_week}{(\emph{Integer} optional): Ending Week - values range from 1-15, 1-14 for seasons pre-playoff, i.e. 2013 or earlier}
}
\value{
\code{\link[=cfbd_stats_season_advanced]{cfbd_stats_season_advanced()}} - A data frame with 81 variables:
\describe{
\item{\code{season}: integer.}{Season of the statistics.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{off_plays}: integer.}{Offense plays in the game.}
\item{\code{off_drives}: integer.}{Offense drives in the game.}
\item{\code{off_ppa}: double.}{Offense predicted points added (PPA).}
\item{\code{off_total_ppa}: double.}{Offense total predicted points added (PPA).}
\item{\code{off_success_rate}: double.}{Offense success rate.}
\item{\code{off_explosiveness}: double.}{Offense explosiveness rate.}
\item{\code{off_power_success}: double.}{Offense power success rate.}
\item{\code{off_stuff_rate}: double.}{Offense rushing stuff rate.}
\item{\code{off_line_yds}: double.}{Offensive line yards.}
\item{\code{off_line_yds_total}: integer.}{Offensive line yards total.}
\item{\code{off_second_lvl_yds}: double.}{Offense second-level yards.}
\item{\code{off_second_lvl_yds_total}: integer.}{Offense second-level yards total.}
\item{\code{off_open_field_yds}: integer.}{Offense open field yards.}
\item{\code{off_open_field_yds_total}: integer.}{Offense open field yards total.}
\item{\code{off_total_opportunities}: integer.}{Offense opportunities.}
\item{\code{off_pts_per_opp}: double.}{Offense points per scoring opportunity.}
\item{\code{off_field_pos_avg_start}: double.}{Offense starting average field position.}
\item{\code{off_field_pos_avg_predicted_points}: double.}{Offense starting average field position predicted points (PP).}
\item{\code{off_havoc_total}: double.}{Offense havoc rate total.}
\item{\code{off_havoc_front_seven}: double.}{Offense front-7 havoc rate.}
\item{\code{off_havoc_db}: double.}{Offense defensive back havoc rate.}
\item{\code{off_standard_downs_rate}: double.}{Offense standard downs rate.}
\item{\code{off_standard_downs_ppa}: double.}{Offense standard downs predicted points added (PPA).}
\item{\code{off_standard_downs_success_rate}: double.}{Offense standard downs success rate.}
\item{\code{off_standard_downs_explosiveness}: double.}{Offense standard downs explosiveness rate.}
\item{\code{off_passing_downs_rate}: double.}{Offense passing downs rate.}
\item{\code{off_passing_downs_ppa}: double.}{Offense passing downs predicted points added (PPA).}
\item{\code{off_passing_downs_success_rate}: double.}{Offense passing downs success rate.}
\item{\code{off_passing_downs_explosiveness}: double.}{Offense passing downs explosiveness rate.}
\item{\code{off_rushing_plays_rate}: double.}{Offense rushing plays rate.}
\item{\code{off_rushing_plays_ppa}: double.}{Offense rushing plays predicted points added (PPA).}
\item{\code{off_rushing_plays_total_ppa}: double.}{Offense rushing plays total predicted points added (PPA).}
\item{\code{off_rushing_plays_success_rate}: double.}{Offense rushing plays success rate.}
\item{\code{off_rushing_plays_explosiveness}: double.}{Offense rushing plays explosiveness rate.}
\item{\code{off_passing_plays_rate}: double.}{Offense passing plays rate.}
\item{\code{off_passing_plays_ppa}: double.}{Offense passing plays predicted points added (PPA).}
\item{\code{off_passing_plays_total_ppa}: double.}{Offense passing plays total predicted points added (PPA).}
\item{\code{off_passing_plays_success_rate}: double.}{Offense passing plays success rate.}
\item{\code{off_passing_plays_explosiveness}: double.}{Offense passing plays explosiveness rate.}
\item{\code{def_plays}: integer.}{Defense plays in the game.}
\item{\code{def_drives}: integer.}{Defense drives in the game.}
\item{\code{def_ppa}: double.}{Defense predicted points added (PPA).}
\item{\code{def_total_ppa}: double.}{Defense total predicted points added (PPA).}
\item{\code{def_success_rate}: double.}{Defense success rate.}
\item{\code{def_explosiveness}: double.}{Defense explosiveness rate.}
\item{\code{def_power_success}: double.}{Defense power success rate.}
\item{\code{def_stuff_rate}: double.}{Defense rushing stuff rate.}
\item{\code{def_line_yds}: double.}{Defense Offensive line yards allowed.}
\item{\code{def_line_yds_total}: integer.}{Defense Offensive line yards total allowed.}
\item{\code{def_second_lvl_yds}: double.}{Defense second-level yards.}
\item{\code{def_second_lvl_yds_total}: integer.}{Defense second-level yards total.}
\item{\code{def_open_field_yds}: integer.}{Defense open field yards.}
\item{\code{def_open_field_yds_total}: integer.}{Defense open field yards total.}
\item{\code{def_total_opportunities}: integer.}{Defense opportunities.}
\item{\code{def_pts_per_opp}: double.}{Defense points per scoring opportunity.}
\item{\code{def_field_pos_avg_start}: double.}{Defense starting average field position.}
\item{\code{def_field_pos_avg_predicted_points}: double.}{Defense starting average field position predicted points (PP).}
\item{\code{def_havoc_total}: double.}{Defense havoc rate total.}
\item{\code{def_havoc_front_seven}: double.}{Defense front-7 havoc rate.}
\item{\code{def_havoc_db}: double.}{Defense defensive back havoc rate.}
\item{\code{def_standard_downs_rate}: double.}{Defense standard downs rate.}
\item{\code{def_standard_downs_ppa}: double.}{Defense standard downs predicted points added (PPA).}
\item{\code{def_standard_downs_success_rate}: double.}{Defense standard downs success rate.}
\item{\code{def_standard_downs_explosiveness}: double.}{Defense standard downs explosiveness rate.}
\item{\code{def_passing_downs_rate}: double.}{Defense passing downs rate.}
\item{\code{def_passing_downs_ppa}: double.}{Defense passing downs predicted points added (PPA).}
\item{\code{def_passing_downs_success_rate}: double.}{Defense passing downs success rate.}
\item{\code{def_passing_downs_explosiveness}: double.}{Defense passing downs explosiveness rate.}
\item{\code{def_rushing_plays_rate}: double.}{Defense rushing plays rate.}
\item{\code{def_rushing_plays_ppa}: double.}{Defense rushing plays predicted points added (PPA).}
\item{\code{def_rushing_plays_total_ppa}: double.}{Defense rushing plays total predicted points added (PPA).}
\item{\code{def_rushing_plays_success_rate}: double.}{Defense rushing plays success rate.}
\item{\code{def_rushing_plays_explosiveness}: double.}{Defense rushing plays explosiveness rate.}
\item{\code{def_passing_plays_rate}: double.}{Defense passing plays rate.}
\item{\code{def_passing_plays_ppa}: double.}{Defense passing plays predicted points added (PPA).}
\item{\code{def_passing_plays_total_ppa}: double.}{Defense passing plays total predicted points added (PPA).}
\item{\code{def_passing_plays_success_rate}: double.}{Defense passing plays success rate.}
\item{\code{def_passing_plays_explosiveness}: double.}{Defense passing plays explosiveness rate.}
}
}
\description{
\strong{Get season advanced statistics by team}
}
\examples{
\donttest{
   cfbd_stats_season_advanced(2019, team = "LSU")
}
}
\keyword{Advanced}
\keyword{Season}
\keyword{Stats}
\keyword{Team}
