% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{as.data.frame.tracks}
\alias{as.data.frame.tracks}
\title{Convert Tracks to Data Frame}
\usage{
\method{as.data.frame}{tracks}(
  x,
  row.names = NULL,
  optional = FALSE,
  include.timepoint.column = FALSE,
  idsAsFactors = TRUE,
  ...
)
}
\arguments{
\item{x}{the \code{tracks} object to be coerced to a data frame.}

\item{row.names}{NULL or a character vector giving row names for the
data frame.  Missing values are not allowed.}

\item{optional}{logical. Required for S3 consistency, but
has no effect: column names are always assigned to the resulting
 data frame regardless of the setting of this option.}

\item{include.timepoint.column}{logical. If set to \code{TRUE}, then the resulting
dataframe will contain a column that consecutively numbers the positions according
to their time. Note that this information is anyway implicitly present in the time
information.}

\item{idsAsFactors}{logical. If \code{TRUE}, then the id column of the resulting
dataframe will be a factor column, otherwise a characeter column.}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
A single data frame containing all individual tracks from the input with a
prepended column named "id" containing each track's identifier in `x`.
}
\description{
Converts tracks from the list-of-matrices format, which is good
for efficient processing and therefore the default in this package, to a
single dataframe which is convenient for plotting or saving the data.
}
\examples{
## Display overall average position of the T cell data
colMeans( as.data.frame( TCells )[-c(1,2)] )
}
