% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scmean.R
\name{scmean}
\alias{scmean}
\title{Single-cell mean log gene expression across cell types}
\usage{
scmean(
  x,
  celltype,
  FUN = "logmean",
  postFUN = NULL,
  verbose = TRUE,
  sliceMem = 16,
  cores = 1L,
  load_balance = FALSE,
  use_future = FALSE
)
}
\arguments{
\item{x}{matrix, sparse matrix or DelayedMatrix of raw counts with genes in
rows and cells in columns.}

\item{celltype}{a vector of cell subclasses or types whose length matches the
number of columns in \code{x}. It is coerced to a factor. \code{NA} are tolerated and
the matching columns in \code{x} are skipped.}

\item{FUN}{Character value or function for applying mean. When applied to a
matrix of count values, this must return a vector. Recommended options are
\code{"logmean"} (the default) or \code{"trimmean"}.}

\item{postFUN}{Optional function to be applied to whole matrix after mean has
been calculated, e.g. \code{log2s}.}

\item{verbose}{Logical, whether to print messages.}

\item{sliceMem}{Max amount of memory in GB to allow for each subsetted count
matrix object. When \code{x} is subsetted by each cell subclass, if the amount
of memory would be above \code{sliceMem} then slicing is activated and the
subsetted count matrix is divided into chunks and processed separately.
This is indicated by addition of '...' in the timings. The limit is just
under 17.2 GB (2^34 / 1e9). At this level the subsetted matrix breaches the
long vector limit (>2^31 elements).}

\item{cores}{Integer, number of cores to use for parallelisation using
\code{mclapply()}. Parallelisation is not available on windows. Warning:
parallelisation increases the memory requirement by multiples of
\code{sliceMem}. \code{cores} is ignored if \code{use_future = TRUE}.}

\item{load_balance}{Logical, whether to load balance memory requirements
across cores (experimental).}

\item{use_future}{Logical, whether to use the future backend for
parallelisation via \code{future_lapply()} instead of the default which is
\code{mclapply()}. Note, the \code{future.apply} package needs to be installed to
enable this.}
}
\value{
a matrix of mean log2 gene expression across cell types with genes
in rows and cell types in columns.
}
\description{
Workhorse function which takes as input a scRNA-Seq gene expression matrix
such as embedded in a Seurat object, calculates log2(counts +1) and averages
gene expression over a vector specifying cell subclasses or cell types. Very
large matrices are handled by slicing rows into blocks to avoid excess memory
requirements.
}
\details{
Mean functions which can be applied by setting \code{FUN} include \code{logmean} (the
default) which applies row means to log2(counts+1), or \code{trimmean} which
calculates the trimmed mean of the counts after top/bottom 5\% of values have
been excluded. Alternatively \code{FUN = rowMeans} calculates the arithmetic mean
of counts.

If \code{FUN = trimmean} or \code{rowMeans}, \code{postFUN} needs to be set to \code{log2s} which
is a simple function which applies log2(x+1).

\code{sliceMem} can be set lower on machines with less RAM, but this will slow the
analysis down. \code{cores} increases the theoretical amount of memory required to
around \code{cores * sliceMem} in GB. For example on a 64 GB machine, we find a
significant speed increase with \code{cores = 3L}. Above this level, there is a
risk that memory swap will slow down processing.
}
\seealso{
\code{\link[=scapply]{scapply()}} which is a more general version which can apply any
function to the matrix. \code{\link[=logmean]{logmean}},
\code{\link[=trimmean]{trimmean}} are options for controlling the type of
mean applied.
}
\author{
Myles Lewis
}
