% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/caretStack.R
\name{predict.caretStack}
\alias{predict.caretStack}
\title{Make predictions from a caretStack}
\usage{
\method{predict}{caretStack}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{a  \code{\link{caretStack}} to make predictions from.}

\item{newdata}{a new dataframe to make predictions on}

\item{...}{arguments to pass to \code{\link{predict.train}}.}
}
\description{
Make predictions from a caretStack. This function passes the data to each function in
turn to make a matrix of predictions, and then multiplies that matrix by the vector of
weights to get a single, combined vector of predictions.
}
\examples{
\dontrun{
library('rpart')
models <- caretList(
  x=iris[1:100,1:2],
  y=iris[1:100,3],
  trControl=trainControl(method='cv'),
  methodList=c('rpart', 'glm')
)
meta_model <- caretStack(models, method='lm')
RMSE(predict(meta_model, iris[101:150,1:2]), iris[101:150,3])
}
}

