\name{xyplot.resamples}
\alias{xyplot.resamples}
\alias{densityplot.resamples}
\alias{bwplot.resamples}
\alias{splom.resamples}
\alias{parallel.resamples}
\alias{dotplot.resamples}

\title{Lattice Functions for Visualizing Resampling Results}

\description{
Lattice functions for visualizing resampling results across models
}
\usage{
\method{xyplot}{resamples}(x, data = NULL, models = x$models[1:2], metric = x$metric[1], ...)

\method{dotplot}{resamples}(x, data = NULL, models = x$models, metric = x$metric, conf.level = 0.95, ...)

\method{densityplot}{resamples}(x, data = NULL, models = x$models, metric = x$metric, ...)

\method{bwplot}{resamples}(x, data = NULL, models = x$models, metric = x$metric, ...)

\method{splom}{resamples}(x, data = NULL, variables = "models", models = x$models, metric = NULL, panelRange = NULL, ...)

\method{parallel}{resamples}(x, data = NULL, models = x$models, metric = x$metric[1], ...)

}
\arguments{
  \item{x}{an object generated by \code{resamples}}
  \item{data}{Not used}
  \item{models}{a character string for which models to plot. Note: \code{xyplot} requires exactly two models whereas the other methods can plot more than two.}
  \item{metric}{a character string for which metrics to use as conditioning variables in the plot. \code{splom} requires exactly one metric when \code{variables = "models"} and at least two when \code{variables = "metrics"}.}
  \item{variables}{either "models" or "metrics"; which variable should be treated as the scatter plot variables?}
  \item{panelRange}{a common range for the panels. If \code{NULL}, the panel ranges are derived from the values across all the models}
  \item{conf.level}{the confidence level for intervals about the mean (obtained using \code{\link[stats]{t.test}})}
  \item{\dots}{further arguments to pass to either \code{\link[lattice:histogram]{histogram}}, \code{\link[lattice:histogram]{densityplot}}, \code{\link[lattice:xyplot]{xyplot}}, \code{\link[lattice:xyplot]{dotplot}} or \code{\link[lattice:splom]{splom}}}
}
\details{
The ideas and methods here are based on Hothorn et al (2005) and Eugster et al (2008).

\code{xyplot} only uses two models in the plot. The plot uses difference of the models on the y-axis and the average of the models on the x-axis.

\code{dotplot} plots the average performance value (with two-sided confidence limits) for each model and metric.

\code{densityplot} and \code{bwplot} display univariate visualizations of the resampling distributions while \code{splom} shows the pair-wise relationships.
}
\value{
a lattice object
}

\references{Hothorn et al. The design and analysis of benchmark experiments. Journal of Computational and Graphical Statistics (2005) vol. 14 (3) pp. 675-699

Eugster et al. Exploratory and inferential analysis of benchmark experiments. Ludwigs-Maximilians-Universitat Munchen, Department of Statistics, Tech. Rep (2008) vol. 30}

\author{Max Kuhn}

\seealso{
\code{\link{resamples}}, \code{\link[lattice:xyplot]{dotplot}}, \code{\link[lattice:bwplot]{bwplot}}, \code{\link[lattice:histogram]{densityplot}}, \code{\link[lattice:xyplot]{xyplot}}, \code{\link[lattice:splom]{splom}}
}
\examples{
\dontrun{
#load(url("http://caret.r-forge.r-project.org/Classification_and_Regression_Training_files/exampleModels.RData"))

resamps <- resamples(list(CART = rpartFit,
                          CondInfTree = ctreeFit,
                          MARS = earthFit))

dotplot(resamps, 
        scales =list(x = list(relation = "free")), 
        between = list(x = 2))

bwplot(resamps,
       metric = "RMSE")

densityplot(resamps,
            auto.key = list(columns = 3),
            pch = "|")

xyplot(resamps,
       models = c("CART", "MARS"),
       metric = "RMSE")

splom(resamps, metric = "RMSE")
splom(resamps, variables = "metrics")

parallel(resamps, metric = "RMSE")


}
}

\keyword{hplot}
