% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphere.R
\name{gen_clusteredspheres}
\alias{gen_clusteredspheres}
\title{Generate Small Spheres Within a Big Sphere}
\usage{
gen_clusteredspheres(
  n = c(1000, 100),
  k = 3,
  p = 4,
  r = c(15, 3),
  loc = 10/sqrt(3)
)
}
\arguments{
\item{n}{A numeric vector (default: c(1000, 100)) representing the sample sizes of the big and small spheres respectively.}

\item{k}{A numeric value (default: 3) representing the number of small spheres.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{r}{A numeric vector (default: c(15, 3)) representing the radius of the big and small spheres respectively.}

\item{loc}{A numeric value (default: 10 / sqrt(3) representing how far the small spheres are placed from each other.}
}
\value{
A data containing small spheres within a big sphere.
}
\description{
This function generates a dataset representing a structure with a small and big spheres.
}
\examples{
set.seed(20240412)
clusteredspheres <- gen_clusteredspheres(n = c(1000, 100), k = 3, p = 4,
r = c(15, 3), loc = 10 / sqrt(3))
}
