% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-param.R
\name{sim_ssvs_var}
\alias{sim_ssvs_var}
\alias{sim_ssvs_vhar}
\title{Generate SSVS Parameters}
\usage{
sim_ssvs_var(
  bayes_spec,
  p,
  dim_data = NULL,
  include_mean = TRUE,
  relax = FALSE,
  method = c("eigen", "chol")
)

sim_ssvs_vhar(
  bayes_spec,
  har = c(5, 22),
  dim_data = NULL,
  include_mean = TRUE,
  relax = c("no", "minnesota", "longrun"),
  method = c("eigen", "chol")
)
}
\arguments{
\item{bayes_spec}{A SSVS model specification by \code{\link[=set_ssvs]{set_ssvs()}}.}

\item{p}{VAR lag}

\item{dim_data}{Specify the dimension of the data if hyperparameters of \code{bayes_spec} have constant values.}

\item{include_mean}{Add constant term (Default: \code{TRUE}) or not (\code{FALSE})}

\item{relax}{Only use off-diagonal terms of each coefficient matrices for restriction.
In \code{sim_ssvs_var()} function, use \code{TRUE} or \code{FALSE} (default).
In \code{sim_ssvs_vhar()} function, \code{"no"} (default), \code{"minnesota"} type, or \code{"longrun"} type.}

\item{method}{Method to compute \eqn{\Sigma^{1/2}}.}

\item{har}{Numeric vector for weekly and monthly order. By default, \code{c(5, 22)}.}
}
\value{
List including coefficients.
}
\description{
This function generates parameters of VAR with SSVS prior.
}
\section{VAR(p) with SSVS prior}{

Let \eqn{\alpha} be the vectorized coefficient of VAR(p).
\deqn{(\alpha \mid \gamma)}
\deqn{(\gamma_i)}
\deqn{(\eta_j \mid \omega_j)}
\deqn{(\omega_{ij})}
\deqn{(\psi_{ii}^2)}
}

\section{VHAR with SSVS prior}{

Let \eqn{\phi} be the vectorized coefficient of VHAR.
\deqn{(\phi \mid \gamma)}
\deqn{(\gamma_i)}
\deqn{(\eta_j \mid \omega_j)}
\deqn{(\omega_{ij})}
\deqn{(\psi_{ii}^2)}
}

\references{
George, E. I., & McCulloch, R. E. (1993). \emph{Variable Selection via Gibbs Sampling}. Journal of the American Statistical Association, 88(423), 881–889.

George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions}. Journal of Econometrics, 142(1), 553–580.

Ghosh, S., Khare, K., & Michailidis, G. (2018). \emph{High-Dimensional Posterior Consistency in Bayesian Vector Autoregressive Models}. Journal of the American Statistical Association, 114(526).

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267–358.
}
