% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparam.R, R/print-bvharspec.R
\name{set_ssvs}
\alias{set_ssvs}
\alias{print.ssvsinput}
\alias{knit_print.ssvsinput}
\title{Stochastic Search Variable Selection (SSVS) Hyperparameter for Coefficients Matrix and Cholesky Factor}
\usage{
set_ssvs(
  coef_spike = 0.1,
  coef_slab = 5,
  coef_mixture = 0.5,
  mean_non = 0,
  sd_non = 0.1,
  shape = 0.01,
  rate = 0.01,
  chol_spike = 0.1,
  chol_slab = 5,
  chol_mixture = 0.5
)

\method{print}{ssvsinput}(x, digits = max(3L, getOption("digits") - 3L), ...)

knit_print.ssvsinput(x, ...)
}
\arguments{
\item{coef_spike}{Standard deviance for Spike normal distribution (See Details).}

\item{coef_slab}{Standard deviance for Slab normal distribution (See Details).}

\item{coef_mixture}{Bernoulli parameter for sparsity proportion (See Details).}

\item{mean_non}{Prior mean of unrestricted coefficients}

\item{sd_non}{Standard deviance for unrestricted coefficients}

\item{shape}{Gamma shape parameters for precision matrix (See Details).}

\item{rate}{Gamma rate parameters for precision matrix (See Details).}

\item{chol_spike}{Standard deviance for Spike normal distribution, in the cholesky factor (See Details).}

\item{chol_slab}{Standard deviance for Slab normal distribution, in the cholesky factor (See Details).}

\item{chol_mixture}{Bernoulli parameter for sparsity proportion, in the cholesky factor (See Details).}

\item{x}{\code{ssvsinput} object}

\item{digits}{digit option to print}

\item{...}{not used}
}
\value{
\code{ssvsinput} object
}
\description{
Set SSVS hyperparameters for VAR or VHAR coefficient matrix and Cholesky factor.
}
\details{
Let \eqn{\alpha} be the vectorized coefficient, \eqn{\alpha = vec(A)}.
Spike-slab prior is given using two normal distributions.
\deqn{\alpha_j \mid \gamma_j \sim (1 - \gamma_j) N(0, \tau_{0j}^2) + \gamma_j N(0, \tau_{1j}^2)}
As spike-slab prior itself suggests, set \eqn{\tau_{0j}} small (point mass at zero: spike distribution)
and set \eqn{\tau_{1j}} large (symmetric by zero: slab distribution).

\eqn{\gamma_j} is the proportion of the nonzero coefficients and it follows
\deqn{\gamma_j \sim Bernoulli(p_j)}
\itemize{
\item \code{coef_spike}: \eqn{\tau_{0j}}
\item \code{coef_slab}: \eqn{\tau_{1j}}
\item \code{coef_mixture}: \eqn{p_j}
\item \eqn{j = 1, \ldots, mk}: vectorized format corresponding to coefficient matrix
\item If one value is provided, model function will read it by replicated value.
\item \code{coef_non}: vectorized constant term is given prior Normal distribution with variance \eqn{cI}. Here, \code{coef_non} is \eqn{\sqrt{c}}.
}

Next for precision matrix \eqn{\Sigma_e^{-1}}, SSVS applies Cholesky decomposition.
\deqn{\Sigma_e^{-1} = \Psi \Psi^T}
where \eqn{\Psi = \{\psi_{ij}\}} is upper triangular.

Diagonal components follow the gamma distribution.
\deqn{\psi_{jj}^2 \sim Gamma(shape = a_j, rate = b_j)}
For each row of off-diagonal (upper-triangular) components, we apply spike-slab prior again.
\deqn{\psi_{ij} \mid w_{ij} \sim (1 - w_{ij}) N(0, \kappa_{0,ij}^2) + w_{ij} N(0, \kappa_{1,ij}^2)}
\deqn{w_{ij} \sim Bernoulli(q_{ij})}
\itemize{
\item \code{shape}: \eqn{a_j}
\item \code{rate}: \eqn{b_j}
\item \code{chol_spike}: \eqn{\kappa_{0,ij}}
\item \code{chol_slab}: \eqn{\kappa_{1,ij}}
\item \code{chol_mixture}: \eqn{q_{ij}}
\item \eqn{j = 1, \ldots, mk}: vectorized format corresponding to coefficient matrix
\item \eqn{i = 1, \ldots, j - 1} and \eqn{j = 2, \ldots, m}: \eqn{\eta = (\psi_{12}, \psi_{13}, \psi_{23}, \psi_{14}, \ldots, \psi_{34}, \ldots, \psi_{1m}, \ldots, \psi_{m - 1, m})^T}
\item \code{chol_} arguments can be one value for replication, vector, or upper triangular matrix.
}
}
\references{
George, E. I., & McCulloch, R. E. (1993). \emph{Variable Selection via Gibbs Sampling}. Journal of the American Statistical Association, 88(423), 881–889.

George, E. I., Sun, D., & Ni, S. (2008). \emph{Bayesian stochastic search for VAR model restrictions}. Journal of Econometrics, 142(1), 553–580.

Koop, G., & Korobilis, D. (2009). \emph{Bayesian Multivariate Time Series Methods for Empirical Macroeconomics}. Foundations and Trends® in Econometrics, 3(4), 267–358.
}
