  /* compute the kronecker product
   * Args: 
   *   A,B: matrices 
   * Returns: 
   *   kronecker product of A and B
   */ 
  matrix kronecker(matrix A, matrix B) { 
    matrix[rows(A)*rows(B), cols(A)*cols(B)] kron; 
    for (i in 1:cols(A)) { 
      for (j in 1:rows(A)) { 
        kron[((j-1)*rows(B)+1):(j*rows(B)), ((i-1)*cols(B)+1):(i*cols(B))] <- A[j,i] * B;
      } 
    } 
    return kron; 
  } 
