% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_club.R
\name{Rich Club}
\alias{Rich Club}
\alias{rich_club_coeff}
\alias{rich_club_all}
\alias{rich_club_norm}
\alias{rich_core}
\title{Rich club calculations}
\usage{
rich_club_coeff(g, k = 1, weighted = FALSE, A = NULL)

rich_club_all(g, weighted = FALSE, A = NULL)

rich_club_norm(g, N = 100, rand = NULL, ...)

rich_core(g, weighted = FALSE, A = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{k}{Integer; the minimum degree for including a vertex. Default: 1}

\item{weighted}{Logical indicating whether or not edge weights should be
used. Default: \code{FALSE}}

\item{A}{Numeric matrix; the adjacency matrix of the input graph. Default:
\code{NULL}}

\item{N}{Integer; the number of random graphs to generate. Default: 100}

\item{rand}{A list of \code{igraph} graph objects, if random graphs have
already been generated. Default: \code{NULL}}

\item{...}{Other parameters (passed to \code{\link{sim.rand.graph.par}})}
}
\value{
\code{\link{rich_club_coeff}} - a list with components:
  \item{phi}{The rich club coefficient, \eqn{\phi}.}
  \item{graph}{A subgraph containing only the rich club vertices.}
  \item{Nk,Ek}{The number of vertices/edges in the rich club graph.}

\code{\link{rich_club_all}} - a \code{data.table} with components:
  \item{k}{A vector of all vertex degrees present in the original graph}
  \item{phi}{The rich-club coefficient}
  \item{Nk,Ek}{The number of vertices/edges in the rich club for each
    successive \emph{k}}

\code{\link{rich_club_norm}} - a data table with columns:
  \item{k}{Sequence of degrees}
  \item{rand}{Rich-club coefficients for the random graphs}
  \item{orig}{Rich-club coefficients for the original graph.}
  \item{norm}{Normalized rich-club coefficients.}
  \item{p}{P-values based on the distribution of \code{rand}}
  \item{p.fdr}{The FDR-adjusted P-values}
  \item{density}{The observed graph's density}
  \item{threshold,Group,name}{}

\code{\link{rich_core}} - a data table with columns:
  \item{density}{The density of the graph.}
  \item{rank}{The rank of the boundary for the rich core.}
  \item{k.r}{The degree/strength of the vertex at the boundary.}
  \item{core.size}{The size of the core relative to the graph size.}
  \item{weighted}{Whether or not weights were used}
}
\description{
\code{rich_club_coeff} calculates the \emph{rich club} of a graph, returning
the rich-club coefficient, \eqn{\phi}, and the subgraph of rich club
vertices.

\code{rich_club_all} is a wrapper for \code{\link{rich_club_coeff}} that
calculates the rich-club coefficient for all degrees present in the graph. It
returns a \code{data.table} with the coefficients and vertex and edge counts
for each successive rich club.

\code{rich_club_norm} will (optionally) generate a number of random graphs,
calculate their rich club coefficients (\eqn{\phi}), and return
\eqn{\phi_{norm}} of the graph of interest, which is the observed rich-club
coefficient divided by the mean across the random graphs.

\code{rich_core} finds the boundary of the rich core of a graph, based on the
decreasing order of vertex degree. It also calculates the degree that
corresponds to that rank, and the core size relative to the total number of
vertices in the graph.
}
\details{
If random graphs have already been generated, you can supply a list as an
argument.

For weighted graphs, the degree is substituted by a normalized weight:
\deqn{ceiling(A / w_{min})}
where \eqn{w_{min}} is the minimum weight (that is greater than 0), and
\eqn{ceiling()} is the \emph{ceiling} function that rounds up to the nearest
integer.
}
\references{
Zhou, S. and Mondragon, R.J. (2004) The rich-club phenomenon
  in the internet topology. \emph{IEEE Comm Lett}, \bold{8}, 180--182.
  \doi{10.4018/978-1-59140-993-9.ch066}

Opsahl, T. and Colizza, V. and Panzarasa, P. and Ramasco, J.J.
  (2008) Prominence and control: the weighted rich-club effect. \emph{Physical
  Review Letters}, \bold{101.16}, 168702.
  \doi{10.1103/PhysRevLett.101.168702}

Colizza, V. and Flammini, A. and Serrano, M.A. and Vespignani, A.
  (2006) Detecting rich-club ordering in complex networks. \emph{Nature
  Physics}, \bold{2}, 110--115. \doi{10.1038/nphys209}

Ma, A and Mondragon, R.J. (2015) Rich-cores in networks.
  \emph{PLoS One}, \bold{10(3)}, e0119678.
  \doi{10.1371/journal.pone.0119678}
}
\seealso{
Other Rich-club functions: \code{\link{plot_rich_norm}},
  \code{\link{rich_club_attrs}}

Other Random graph functions: \code{\link{Random Graphs}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Random graph functions}
\concept{Rich-club functions}
