% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{evaluatePriorLambda}
\alias{evaluatePriorLambda}
\title{evaluatePriorLambda}
\usage{
evaluatePriorLambda(p, m, alpha2, qVec, psy, lambda, constraint, clusInd)
}
\arguments{
\item{p}{the number of features}

\item{m}{the number of clusters}

\item{alpha2}{hyper parameter}

\item{qVec}{the vector of the number of factors in each clusters}

\item{psy}{parameter}

\item{lambda}{parameter}

\item{constraint}{the pgmm constraint, a vector of length three with binary entry. For example, c(1,1,1) means the fully constraint model}

\item{clusInd}{cluster indicator vector}
}
\description{
evaluate prior value for parameter Lambda
}
\examples{
p <- 10
m <- 20
alpha2 <- 1.18
qVec <- rep(4, m)
delta <- 2
bbeta <- 2
constraint <- c(0, 0, 0)
psy <- generatePriorPsi(
  p,
  m,
  delta,
  bbeta,
  constraint
)
lambda <- generatePriorLambda(
  p,
  m,
  alpha2,
  qVec,
  psy,
  constraint
)
clusInd <- rep(1, m)
#'
\donttest{
evaluatePriorLambda(
  p,
  m,
  alpha2,
  qVec,
  psy,
  lambda,
  constraint,
  clusInd
)
}
}
