% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_pattern_analysis.R
\name{get_pattern}
\alias{basic_pattern_analysis}
\alias{basic_pattern_analysis.data.frame}
\alias{basic_pattern_analysis.default}
\alias{bpa}
\alias{get_pattern}
\title{Basic Pattern Analysis}
\usage{
get_pattern(x, show_ws = TRUE, ws_char = "w")

basic_pattern_analysis(x, unique_only = FALSE, show_ws = TRUE,
  ws_char = "w", useNA = c("no", "ifany", "always"), ...)

\method{basic_pattern_analysis}{default}(x, unique_only = FALSE,
  show_ws = TRUE, ws_char = "w", useNA = c("no", "ifany", "always"), ...)

\method{basic_pattern_analysis}{data.frame}(x, unique_only = FALSE,
  show_ws = TRUE, ws_char = "w", useNA = c("no", "ifany", "always"), ...)

bpa(x, ...)
}
\arguments{
\item{x}{A data frame or character vector.}

\item{show_ws}{Logical indicating whether or not to show whitespace
using a special character. Default is \code{TRUE}.}

\item{ws_char}{Character string to use to depict whitespace when 
\code{show_ws = TRUE}.}

\item{unique_only}{Logical indicating whether or not to only show the unique
patterns. Default is \code{TRUE}.}

\item{useNA}{Logical indicating whether to include \code{NA} values in the
table. See \code{\link{table}} for details.}

\item{...}{Additional optional arguments to be passed onto \code{llply}.}
}
\description{
Perform a basic pattern analysis
}
\examples{
basic_pattern_analysis(iris)
basic_pattern_analysis(iris, unique_only = TRUE)
}

