% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use.r
\name{importing}
\alias{importing}
\alias{use_one}
\alias{load_and_register}
\alias{register_as_import}
\alias{defer_import_finalization}
\alias{finalize_deferred}
\alias{export_and_attach}
\alias{load_from_source}
\alias{load_mod}
\alias{mod_exports}
\alias{mod_export_names}
\alias{attach_to_caller}
\alias{attach_list}
\alias{assign_alias}
\alias{assign_temp_alias}
\title{Import a module or package}
\usage{
use_one(declaration, alias, caller, use_call)

load_and_register(spec, info, caller)

register_as_import(spec, info, mod_ns, caller)

defer_import_finalization(spec, info, mod_ns, caller)

finalize_deferred(info)

export_and_attach(spec, info, mod_ns, caller)

load_from_source(info, mod_ns)

load_mod(info)

mod_exports(info, spec, mod_ns)

mod_export_names(info, mod_ns)

attach_to_caller(spec, info, mod_exports, mod_ns, caller)

attach_list(spec, exports)

assign_alias(spec, mod_exports, caller)

assign_temp_alias(spec, caller)
}
\arguments{
\item{declaration}{an unevaluated use declaration expression without the
surrounding \code{use} call}

\item{alias}{the use alias, if given, otherwise \code{NULL}}

\item{caller}{the client’s calling environment (parent frame)}

\item{use_call}{the \code{use} call which is invoking this code}

\item{spec}{a module use declaration specification}

\item{info}{the physical module information}

\item{mod_ns}{the module namespace environment of the newly loaded module}
}
\value{
\code{use_one} does not currently return a value. — This might change
in the future.

\code{load_mod} returns the module or package namespace environment
of the specified module or package info.

\code{mod_exports} returns an export environment containing the
exported names of a given module.

\code{mode_export_names} returns a vector containing the same names as
\code{names(mod_exports(info, spec, mod_ns))} but does not create an export
environment.

\code{attach_list} returns a named character vector of the names in
an attach specification. The vector’s names are the aliases, if provided, or
the attach specification names themselves otherwise.
}
\description{
Actual implementation of the import process
}
\details{
\code{use_one} performs the actual import. It is invoked by \code{use} given
the calling context and unevaluated expressions as arguments, and only uses
standard evaluation.

\code{load_and_register} performs the loading, attaching and exporting of a
module identified by its spec and info.

\code{register_as_import} registers a \code{use} declaration in the calling
module so that it can be found later on, if the declaration is reexported by
the calling module.

\code{defer_import_finalization} is called by \code{load_and_register} to
earmark a module for deferred initialization if it hasn’t been fully loaded
yet.

\code{finalize_deferred} exports and attaches names from a module use
declaration which has been deferred due to being part of a cyclic loading
chain.

\code{export_and_attach} exports and attaches names from a given module use
declaration.

\code{load_from_source} loads a module source file into its newly created,
empty module namespace.

\code{load_mod} tests whether a module or package was already loaded and, if
not, loads it.

\code{mod_exports} returns an export environment containing a copy of the
module’s exported objects.

\code{attach_to_caller} attaches the listed names of an attach specification
for a given use declaration to the calling environment.

\code{assign_alias} creates a module/package object in calling environment,
unless it contains an attach declaration, and no explicit alias is given.

\code{assign_temp_alias} creates a placeholder object for the module in the
calling environment, to be replaced by the actual module export environment
once the module is completely loaded (which happens in the case of cyclic
imports).
}
\note{
If a module is still being loaded (because it is part of a cyclic
import chain), \code{load_and_register} earmarks the module for deferred
registration and holds off on attaching and exporting for now, since not all
its names are available yet.
}
\keyword{internal}
