% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillLineGaps.R
\name{fillLineGaps}
\alias{fillLineGaps}
\title{Reconnecting discontinuous lines}
\usage{
fillLineGaps(
  contours,
  objects = NULL,
  threshold = "13\%",
  alpha = 1,
  sigma = 2,
  radius = 5,
  iterations = 2,
  visualize = TRUE
)
}
\arguments{
\item{contours}{image that contains discontinuous lines like edges or
contours}

\item{objects}{image that contains objects that should be removed before
applying the fill algorithm}

\item{threshold}{"in \%" (from \code{\link[imager]{threshold}})}

\item{alpha}{threshold adjustment factor for edge detection
(from \code{\link[biopixR]{edgeDetection}})}

\item{sigma}{smoothing (from \code{\link[biopixR]{edgeDetection}})}

\item{radius}{maximal radius that should be scanned for another cluster}

\item{iterations}{how many times the algorithm should find line ends and
reconnect them to their closest neighbor}

\item{visualize}{if TRUE (default) a plot is displayed highlighting the
added pixels in the original image}
}
\value{
Image with continuous edges (closed gaps).
}
\description{
The function attempts to fill in edge discontinuities in order to enable
normal labeling and edge detection.
}
\details{
The function pre-processes the image in order to enable the implementation
of the \code{\link[biopixR]{adaptiveInterpolation}} function. The
pre-processing stage encompasses a number of operations, including
thresholding, the optional removal of objects, the detection of line ends
and diagonal line ends, and the labeling of pixels. The threshold should be
set to allow for the retention of some "bridge" pixels between gaps, thus
facilitating the subsequent process of reconnection. For further details
regarding the process of reconnection, please refer to the documentation on
\code{\link[biopixR]{adaptiveInterpolation}}. The subsequent post-processing
stage entails the reduction of line thickness in the image. With regard to
the possibility of object removal, the coordinates associated with these
objects are collected using the \code{\link[biopixR]{objectDetection}}
function. Subsequently, the pixels of the detected objects are set to null
in the original image, thus allowing the algorithm to proceed without the
objects.
}
\examples{
fillLineGaps(droplets)
}
