context("Generating n-grams")

test_that("create_ngrams works properly for different unigrams and n",{
  ngrams1 <- c("1.1.1", "2.1.1", "1.2.1", "2.2.1", "1.1.2", "2.1.2", "1.2.2", 
              "2.2.2")
  ngrams2 <- c("1.1.1", "2.1.1", "3.1.1", "1.2.1", "2.2.1", "3.2.1", "1.3.1", 
               "2.3.1", "3.3.1", "1.1.2", "2.1.2", "3.1.2", "1.2.2", "2.2.2", 
               "3.2.2", "1.3.2", "2.3.2", "3.3.2", "1.1.3", "2.1.3", "3.1.3", 
               "1.2.3", "2.2.3", "3.2.3", "1.3.3", "2.3.3", "3.3.3")
  ngrams3 <- c("a.a", "c.a", "a.c", "c.c")
  ngrams4 <- c("1_1.1", "2_1.1", "1_2.1", "2_2.1", "1_3.1", "2_3.1", "1_4.1", 
               "2_4.1", "1_1.2", "2_1.2", "1_2.2", "2_2.2", "1_3.2", "2_3.2", 
               "1_4.2", "2_4.2", "1_1.3", "2_1.3", "1_2.3", "2_2.3", "1_3.3", 
               "2_3.3", "1_4.3", "2_4.3", "1_1.4", "2_1.4", "1_2.4", "2_2.4", 
               "1_3.4", "2_3.4", "1_4.4", "2_4.4")
  expect_identical(ngrams1, create_ngrams(3, 1:2))  
  expect_identical(ngrams2, create_ngrams(3, 1:3))  
  expect_identical(ngrams3, create_ngrams(2, c("a", "c")))  
  expect_identical(ngrams4, create_ngrams(2, 1:4, possible_grams = 2)) 
})

