% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngrams.R
\name{seq2ngrams}
\alias{seq2ngrams}
\title{Extract n-grams from sequence}
\usage{
seq2ngrams(seq, n, u, d = 0, pos = FALSE)
}
\arguments{
\item{seq}{a vector or matrix describing sequence(s).}

\item{n}{\code{integer} size of n-gram.}

\item{u}{\code{integer}, \code{numeric} or \code{character} vector of all
possible unigrams.}

\item{d}{\code{integer} vector of distances between elements of n-gram (0 means 
consecutive elements). See Details.}

\item{pos}{\code{logical}, if \code{TRUE} position-specific n_grams are counted.}
}
\value{
A \code{character} matrix of n-grams, where every row corresponds to a
different sequence.
}
\description{
Extracts vector of n-grams present in sequence(s).
}
\details{
A format of \code{d} vector is discussed in Details of 
\code{\link{count_ngrams}}.
}
\examples{
# trigrams from multiple sequences
seqs <- matrix(sample(1L:4, 600, replace = TRUE), ncol = 50)
seq2ngrams(seqs, 3, 1L:4)
}
